<?php

class Sincronizar_model extends CI_Model {

  public function getAll($tabla) {
    return $this->db->get($tabla)->result();
  }

  public function get($id, $tabla) {
    return $this->db->where('id', $id)->get($tabla)->row();
  }

	public function ultimo($tabla) {
		return $this->db->get($tabla)->last_row();
	}

  public function getAlls($tabla) {
    $this->db->from($tabla);
    return $this->db->count_all_results();
  }

  public function getAllP($tabla) {
    return $this->db->where('empresa', $this->empresa)->get($tabla)->result();
  }

  public function backup() {
    $this->load->dbutil();
    $prefs = array(
      'format' => 'zip',
      'filename' => 'my_db_backup.sql'
    );
    $backup =& $this->dbutil->backup($prefs);
    $db_name = 'backup-on-'.date("Y-m-d-H-i-s").'.zip';
    $save = 'backup/'.$db_name;
    $this->load->helper('file');
    write_file($save, $backup);
  }

  public function save($tabla, $data) {
		$this->db->insert($tabla, $data);
		return $this->db->insert_id();
	}

  public function get_by_id($id, $tabla) {
		$this->db->from($tabla);
		$this->db->where('id',$id);
		$query = $this->db->get();
		return $query->row();
	}

  public function update($where, $data, $tabla) {
		$this->db->update($tabla, $data, $where);
		return $this->db->affected_rows();
	}

	public function delete_by_id($id, $tabla) {
		$this->db->where('id', $id);
		$this->db->delete($tabla);
	}

}
