<?php

class Seguimientoajuste_model extends CI_Model
{

	public function getAll($tabla)
	{
		return $this->db->get($tabla)->result();
	}

	public function getAlls($tabla)
	{
		$this->db->from($tabla);
		return $this->db->count_all_results();
	}

	public function get($id, $tabla)
	{
		return $this->db->where('id', $id)->get($tabla)->row();
	}

	public function save($tabla, $data)
	{
		$this->db->insert($tabla, $data);
		return $this->db->insert_id();
	}

	public function get_by_id($id, $tabla)
	{
		$this->db->from($tabla);
		$this->db->where('id', $id);
		$query = $this->db->get();
		return $query->row();
	}

	public function update($where, $data, $tabla)
	{
		$this->db->update($tabla, $data, $where);
		return $this->db->affected_rows();
	}

	public function delete_by_id($id, $tabla)
	{
		$this->db->where('id', $id);
		return $this->db->delete($tabla);
	}

	public function eliminar($id, $tabla)
	{
		return $this->db->where('id', $id)->delete($tabla);
	}

	public function count_all($tabla)
	{
		$this->db->from($tabla);
		return $this->db->count_all_results();
	}
	public function periodo()
	{
		return $this->db->where('estado', '0')->where('educacion', '0')->get('periodo')->row();
	}

	public function getgradodocente($docente)
	{
		$this->db->distinct()->select("grado");
		$this->db->from("docentecurso");
		$this->db->where("docente", $docente);
		$grados = array();
		foreach ($this->db->get()->result() as $key => $value) {
			$grados[$key] = $value->grado;
		}
		return $grados;
	}

	public function listargrados($perfil, $docente)
	{
		if ($perfil == 3) $grados = $this->getgradodocente($docente);
		$this->db->select('v1.*,v2.nombre as nomnivel');
		$this->db->join('nivel v2', 'v2.id=v1.nivel');
		$this->db->where_in('v1.id', ($perfil == 3 ? $grados : null));
		return $this->db->get('grado v1')->result();
	}

	public function listarseccion($grado)
	{
		$row = $this->get($grado, 'grado');
		return $this->db->where('nivel', $row->nivel)->get('seccion')->result();
	}

	public function listarcurso($periodo, $grado, $seccion, $perfil, $docente)
	{
		/* $periodo = $this->periodo();
		if (!$periodo) return FALSE; */
		$this->db->select('v3.*');
		$this->db->from('docentecurso as v1');
		$this->db->join('grado as v2', 'v2.id=v1.grado');
		$this->db->join('curso as v3', 'v3.id=v1.curso');
		$this->db->where('v2.id', $grado);
		$this->db->where('v1.seccion', $seccion);
		$this->db->where('v1.periodo', $periodo);
		if ($perfil == 3) $this->db->where('v1.docente', $docente);
		$this->db->order_by('v3.nombre');
		return $this->db->get()->result();
	}

	public function listarmatricula($periodo, $grado, $seccion)
	{
		$this->db->select('v2.*,v1.id as mat');
		$this->db->from('matricula v1');
		$this->db->join('usuario v2', 'v2.id = v1.alumno');
		$this->db->where('v1.grado', $grado);
		$this->db->where('v1.seccion', $seccion);
		$this->db->where('v1.periodo', $periodo);
		$this->db->order_by('v2.apellido');
		return $this->db->get()->result();
	}
	/* public function buscarasistencia($matricula, $grado, $seccion, $curso, $fecha)
	{
		$this->db->select('v1.*');
		$this->db->from('asistencia v1');
		$this->db->join('docentecurso v2', 'v2.id = v1.docentecurso');
		$this->db->where('v1.matricula', $matricula)->where('v1.created', $fecha);
		$this->db->where('v2.grado', $grado)->where('v2.seccion', $seccion)->where('v2.curso', $curso);
		return $this->db->get()->row();
	} */
	public function buscarasistencia($matricula, $turno, $fecha)
	{
		$this->db->where('matricula', $matricula)->where('turno', $turno)->where('created', $fecha);
		return $this->db->get('asistencia')->row();
	}
	public function buscarasistenciadocente($docente, $turno, $fecha)
	{
		$this->db->where('docente', $docente)->where('turno', $turno)->where('created', $fecha);
		return $this->db->get('asistencia')->row();
	}
	public function buscardocente($grado, $seccion, $curso)
	{
		$this->db->select('v1.*');
		$this->db->from('usuario v1');
		$this->db->join('docentecurso v2', 'v2.docente = v1.id');
		$this->db->where('v2.grado', $grado)->where('v2.seccion', $seccion)->where('v2.curso', $curso);
		return $this->db->get()->row();
	}
	public function buscardocentecurso($grado, $seccion, $curso)
	{
		$this->db->select('v2.*,v1.nombre,v1.apellido');
		$this->db->from('usuario v1');
		$this->db->join('docentecurso v2', 'v2.docente = v1.id');
		$this->db->where('v2.grado', $grado)->where('v2.seccion', $seccion)->where('v2.curso', $curso);
		return $this->db->get()->row();
	}

	public function listardocentes($periodo)
	{
		$this->db->join('docenteasignado v2', 'v2.docente=v1.id');
		$this->db->select('v1.*');
		$this->db->where('v1.perfil', '3');
		$this->db->where('v2.periodo', $periodo);
		$this->db->where('v1.estado', '0');
		$this->db->order_by('v1.apellido');
		return $this->db->get('usuario v1')->result();
	}

	public function completaralumno($q, $periodo)
	{
		$query = $this->db->select('v1.*,v2.periodo,v3.nombre nomgrado,v4.nombre nomseccion')
			->from('usuario as v1')
			->join('matricula as v2', 'v2.alumno=v1.id')
			->join('grado as v3', 'v3.id=v2.grado')
			->join('seccion as v4', 'v4.id=v2.seccion')
			->like('v1.nombre', $q)
			->or_like('v1.apellido', $q)
			->or_like('v1.documento', $q)
			->get();
		if ($query->num_rows() > 0) {
			foreach ($query->result() as $row) {
				if ($row->perfil == 4 && $row->periodo == $periodo) {
					$row_set[] = array(
						'label' => $row->documento . ' | ' . $row->apellido . ', ' . $row->nombre,
						'alumno' => $row->id,
						'nomgrado' => $row->nomgrado,
						'nomseccion' => $row->nomseccion,
					);
				}
			}
		} else {
			$row_set[] = array(
				'label' => 'NOSE ENCONTRARON DATOS',
				'alumno' => '',
			);
		}
		echo json_encode($row_set);
	}

	public function listaralumnos($pariente)
	{
		$this->db->where('perfil', '4');
		$this->db->where('pariente', $pariente);
		return $this->db->get('usuario')->result();
	}

	public function buscarmatricula($periodo, $alumno)
	{
		$this->db->select('v1.*,v2.nombre nomgrado,v3.nombre nomseccion');
		$this->db->from('matricula v1');
		$this->db->join('grado v2', 'v2.id=v1.grado');
		$this->db->join('seccion v3', 'v3.id=v1.seccion');
		$this->db->where('v1.alumno', $alumno)->where('v1.periodo', $periodo);
		return $this->db->get()->row();
	}

	public function periodos($tipoperiodo)
	{
		return $this->db->where('tipoperiodo', $tipoperiodo)->order_by('id', 'desc')->get('periodo')->result();
	}

	public function periodoactual($tipoperiodo)
	{
		return $this->db->where('tipoperiodo', $tipoperiodo)->where('estado', '0')->get('periodo')->row();
	}
}
