<?php

class Menu_model extends CI_Model
{

	public function getAll($tabla)
	{
		return $this->db->get($tabla)->result();
	}

	public function getAlls($tabla)
	{
		return $this->db->from($tabla)->count_all_results();
	}

	public function get($id, $tabla)
	{
		return $this->db->where('id', $id)->get($tabla)->row();
	}

	public function save($tabla, $data)
	{
		$this->db->insert($tabla, $data);
		return $this->db->insert_id();
	}

	public function get_by_id($id, $tabla)
	{
		return $this->db->from($tabla)->where('id', $id)->get()->row();
	}

	public function update($where, $data, $tabla)
	{
		$this->db->update($tabla, $data, $where);
		return $this->db->affected_rows();
	}

	public function delete_by_id($id, $tabla)
	{
		return $this->db->where('id', $id)->delete($tabla);
	}

	public function count_all($tabla)
	{
		return $this->db->from($tabla)->count_all_results();
	}

	public function check($id, $grupo, $menu)
	{
		if ($id) {
			$this->db->where('id !=', $id);
		}
		if ($grupo) {
			$this->db->where('parent_id', $grupo);
		}
		$this->db->where('nombre', $menu);
		return $this->db->get('menu')->result();
	}

	public function getMenu()
	{
		return $this->db->where('parent_id', 0)->get('menu')->result();
	}

	public function getPerfilM($perfil, $menu)
	{
		return $this->db->where('perfil', $perfil)->where('menu', $menu)->get('perfilmenu')->row();
	}
}
