<?php

class Inicio_model extends CI_Model
{

	public function getAll($tabla)
	{
		return $this->db->get($tabla)->result();
	}

	public function get($id, $tabla)
	{
		return $this->db->where('id', $id)->get($tabla)->row();
	}

	public function maximo($tabla)
	{
		return $this->db->where('empresa', $this->empresa)->get($tabla)->last_row();
	}

	public function mis_cursos($usuario, $periodo)
	{
		$this->db->select("v1.*,v2.nombre AS grado_des,v3.nombre AS curso_des");
		$this->db->from("usuariodocente as v1");
		$this->db->join("grado as v2", "v2.id = v1.grado");
		$this->db->join("curso as v3", "v3.id = v1.curso");
		$this->db->where("v1.usuario", $usuario)->where("v1.periodo", $periodo);
		$this->db->order_by('v2.nivel', 'asc');
		return $this->db->get()->result();
	}

	public function nivel_grado($periodo, $usuario)
	{
		$this->db->select('v1.*,v3.nombre as nivel_des,v4.nombre as grado_des');
		$this->db->from('usuario as v1');
		$this->db->join('matricula as v2', 'v2.usuario = v1.id');
		$this->db->join('nivel as v3', 'v3.id = v2.nivel');
		$this->db->join('grado as v4', 'v4.id = v2.grado');
		$this->db->where('v2.periodo', $periodo)->where('v1.pariente', $usuario)->where('v1.perfil', '4');
		return $this->db->get()->result();
	}

	public function grados_docente($periodo, $usuario)
	{
		$mis_grados = $this->idgrado_docente($periodo, $usuario);
		if (count($mis_grados)) {
			$query = $this->db->select("v1.*,v2.nombre as nivel_des")
				->from("`grado` as v1")
				->join('nivel as v2', 'v2.id=v1.nivel', 'inner')
				->where_in("v1.id", $mis_grados)
				->get();
			return $query->result();
		} else {
			return false;
		}
	}

	public function idgrado_docente($periodo, $usuario)
	{
		$this->db->distinct()->select("grado.id");
		$this->db->from("docentecurso dc");
		$this->db->join("grado g", "g.id = dc.grado");
		$this->db->join("curso c", "c.id = dc.curso");
		$query = $this->db->where("dc.usuario", $usuario)->get();
		$grados = array();
		foreach ($query->result() as $key => $value) {
			$grados[$key] = $value->id;
		}
		return $grados;
	}

	public function periodo($tipoperiodo)
	{
		return $this->db->where('estado', '0')->where('tipoperiodo', $tipoperiodo)->get('periodo')->row();
	}

	public function numeromatricula($periodo, $nivel)
	{
		$this->db->from("matricula m");
		$this->db->join("grado g", "g.id = m.grado");
		return $this->db->where('m.periodo', $periodo)->where('g.nivel', $nivel)->count_all_results();
	}

	public function numeros($tabla)
	{
		return $this->db->from($tabla)->count_all_results();
	}

	public function usuarios($perfil)
	{
		return $this->db->where('perfil', $perfil)->where('estado', '0')->from('usuario')->count_all_results();
	}

	public function gradonivel($nivel)
	{
		return $this->db->where('nivel', $nivel)->get('grado')->result();
	}

	public function numeromatriculagrado($grado)
	{
		$this->db->from("matricula m");
		$this->db->join("periodo p", "p.id = m.periodo");
		return $this->db->where('p.estado', '0')->where('m.grado', $grado)->count_all_results();
	}

	public function contadoralumnosporsexo($nivel)
	{
		$this->db->select('count(v1.sexo) conteo');
		$this->db->from('usuario v1');
		$this->db->join('matricula v2', 'v2.alumno=v1.id', 'inner');
		$this->db->join('grado v3', 'v3.id=v2.grado', 'inner');
		$this->db->where('v3.nivel', $nivel);
		$this->db->group_by('sexo');
		return $this->db->get()->result();
	}

	public function listaralumnosdocentegrado($periodo, $docente, $nivel)
	{
		$this->db->select('distinct(v1.id)');
		$this->db->from('grado v1');
		$this->db->join('docentecurso v2', 'v2.grado=v1.id', 'inner');
		$this->db->where('v2.docente', $docente);
		$this->db->where('v1.nivel', $nivel);
		$this->db->where('v2.periodo', $periodo);
		$grados = array();
		foreach ($this->db->get()->result() as $key => $value) {
			$grados[$key] = $value->id;
		}
		if (count($grados)) {
			$this->db->select('count(id) conteo');
			$this->db->from('matricula');
			$this->db->where_in('grado', $grados);
			return $this->db->get()->row();
		} else {
			return false;
		}
	}

	public function listargradosdocente($periodo, $docente, $nivel)
	{
		$this->db->select('distinct(v1.id)')->from('grado v1');
		$this->db->join('docentecurso v2', 'v2.grado=v1.id', 'inner');
		$this->db->where('v2.periodo', $periodo)->where('v2.docente', $docente)->where('v1.nivel', $nivel);
		$this->db->order_by('v1.id');
		$grados = array();
		foreach ($this->db->get()->result() as $key => $value) {
			$grados[$key] = $value->id;
		}
		if (count($grados)) {
			$this->db->where_in('id', $grados);
			return $this->db->get('grado')->result();
		} else {
			return false;
		}
	}

	public function contadoralumnosdocentenivel0($periodo, $docente, $nivel)
	{
		$this->db->select('distinct(v1.id)')->from('grado v1');
		$this->db->join('docentecurso v2', 'v2.grado=v1.id', 'inner');
		$this->db->where('v2.periodo', $periodo)->where('v2.docente', $docente)->where('v1.nivel', $nivel);
		$this->db->order_by('v1.id');
		$grados = array();
		foreach ($this->db->get()->result() as $key => $value) {
			$grados[$key] = $value->id;
		}
		if (count($grados)) {
			$this->db->select('v2.grado,count(v2.grado) conteo');
			$this->db->from('matricula v2');
			$this->db->join('usuario v1', 'v1.id=v2.alumno', 'inner');
			$this->db->where_in('v2.grado', $grados);
			$this->db->where('v1.sexo', '0');
			$this->db->group_by('v2.grado');
			return $this->db->get()->result();
		} else {
			return false;
		}
	}

	public function contadoralumnosdocentenivel1($periodo, $docente, $nivel)
	{
		$this->db->select('distinct(v1.id)')->from('grado v1');
		$this->db->join('docentecurso v2', 'v2.grado=v1.id', 'inner');
		$this->db->where('v2.periodo', $periodo)->where('v2.docente', $docente)->where('v1.nivel', $nivel);
		$this->db->order_by('v1.id');
		$grados = array();
		foreach ($this->db->get()->result() as $key => $value) {
			$grados[$key] = $value->id;
		}
		if (count($grados)) {
			$this->db->select('v2.grado,count(v2.grado) conteo');
			$this->db->from('matricula v2');
			$this->db->join('usuario v1', 'v1.id=v2.alumno', 'inner');
			$this->db->where_in('v2.grado', $grados);
			$this->db->where('v1.sexo', '1');
			$this->db->group_by('v2.grado');
			return $this->db->get()->result();
		} else {
			return false;
		}
	}

	public function contadoralumnosasistenciahoy($nivel, $tipo)
	{
		$this->db->select('id,0 as conteo');
		$this->db->where('nivel', $nivel);
		$grados = $this->db->get('grado')->result();
		$this->db->select('v1.grado,count(v1.grado) as conteo');
		$this->db->from('matricula v1');
		$this->db->join('grado v2', 'v2.id=v1.grado')->join('asistencia v3', 'v3.matricula=v1.id');
		$this->db->where('v2.nivel', $nivel)->where('v3.created', date('Y-m-d'));
		$this->db->where('v3.tipo', $tipo)->where('v3.reg_primero', '1');
		$this->db->group_by('v1.grado');
		$gradoconteo = $this->db->get()->result();
		foreach ($grados as $key => $x) {
			foreach ($gradoconteo as $y) {
				if ($x->id == $y->grado) {
					$x->conteo = $y->conteo;
					break;
				}
			}
		}
		return $grados;
	}

	public function getmatricula($alumno)
	{
		$this->db->select('m.*');
		$this->db->from("matricula m");
		$this->db->join("periodo p", "p.id = m.periodo");
		$this->db->where('p.estado', '0');
		$this->db->where('m.alumno', $alumno);
		$this->db->where('m.estado', '0');
		return $this->db->get()->row();
	}

	public function buscarperiodogrado($alumno)
	{
		$this->db->select('v2.descripcion periodonom,concat(v3.nombre,\' - \',v5.nombre) gradonom');
		$this->db->from('matricula v1');
		$this->db->join('periodo v2', 'v2.id=v1.periodo');
		$this->db->join('grado v3', 'v3.id=v1.grado');
		$this->db->join('seccion v5', 'v5.id=v1.seccion');
		$this->db->where('v1.alumno', $alumno);
		$this->db->where('v1.estado', '0');
		$this->db->where('v2.estado', '0');
		return $this->db->get()->row();
	}

	public function allcursosalumno($periodo, $grado, $seccion)
	{
		$this->db->select('v1.*,v3.apellido,v3.nombre nombred');
		$this->db->from('curso v1');
		$this->db->join('docentecurso v2', 'v2.curso=v1.id');
		$this->db->join('usuario v3', 'v3.id=v2.docente');
		$this->db->where('v2.periodo', $periodo);
		$this->db->where('v2.grado', $grado);
		$this->db->where('v2.seccion', $seccion);
		return $this->db->get()->result();
	}

	public function listaralumnos($periodo,$pariente)
	{
		$this->db->select('v1.*,concat(v3.nombre,\' \',v4.nombre) as gradon');
		$this->db->from('usuario v1');
		$this->db->join('matricula v2', 'v2.alumno=v1.id');
		$this->db->join('grado v3', 'v3.id=v2.grado');
		$this->db->join('seccion v4', 'v4.id=v2.seccion');
		$this->db->where('v1.perfil', '4');
		$this->db->where('v2.periodo', $periodo);
		$this->db->where('v1.pariente', $pariente);
		$this->db->order_by('v3.id asc');
		return $this->db->get()->result();
	}

	public function sumamontodiario($tabla)
	{
		$this->db->select_sum('monto');
		$this->db->where('empresa', $this->empresa);
		$this->db->where('created', date('Y-m-d'));
		return $this->db->get($tabla)->row();
	}

	public function sumamontomensual($tabla)
	{
		$this->db->select_sum('monto');
		$this->db->where('empresa', $this->empresa);
		$this->db->where('MONTH(created)', date('m'));
		$this->db->where('YEAR(created)', date('Y'));
		return $this->db->get($tabla)->row();
	}

	public function grafico($usuario, $mes, $ano, $tabla)
	{
		$this->db->select_sum('monto');
		$this->db->where('MONTH(created)', $mes);
		$this->db->where('YEAR(created)', $ano);
		$this->db->where('empresa', $this->empresa);
		if ($usuario) {
			$this->db->where('usuario', $usuario);
		}
		return $this->db->get($tabla)->row();
	}
	public function periodoactual($tipoperiodo)
	{
		return $this->db->where('tipoperiodo', $tipoperiodo)->where('estado', '0')->get('periodo')->row();
	}
}
