<?php

class Usuario extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(modelo(), 'Controlador_model');
        $this->controlador = controlador();
        $this->titulo_controlador = humanize($this->controlador);
        $this->url = base_url() . $this->controlador;
        $this->vista = $this->controlador;
        $this->perfil = $this->session->userdata('perfil') ? $this->session->userdata('perfil') : FALSE;
        $this->usuario = $this->session->userdata('usuario') ? $this->session->userdata('usuario') : FALSE;
        $this->empresa = $this->session->userdata('empresa') ? $this->session->userdata('empresa') : FALSE;
    }

    public function index()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista,
            'perfil' => null,
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function cargarperfil()
    {
        $datas = $this->Controlador_model->getAll('perfil');
        echo json_encode(array('perfiles' => $datas));
    }

    public function ajax_list()
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $query = $this->db->order_by('id', 'desc')->get($this->controlador)->result();
        $data = [];
        $estado['0'] = '<span class="badge badge-success">ACTIVO</span>';
        $estado['1'] = '<span class="badge badge-danger">DESABILITADO</span>';
        foreach ($query as $key => $value) {
            $perfil = $this->Controlador_model->get($value->perfil, 'perfil');
            //add variables for action
            $boton = '';
            //add html for action
            if ($this->perfil == 1) {
                $boton .= '<a class="btn btn-xs btn-danger" href="javascript:void(0)" title="Modificar" onclick="edit(' . $value->id . ')"><i class="fa fa-pencil"></i></a> ';
                $boton .= '<a class="btn btn-xs btn-primary" href="javascript:void(0)" title="Borrar" onclick="borrar(' . $value->id . ')"><i class="fa fa-trash"></i></a> ';
                if ($value->estado == '0') {
                    $boton .= '<a class="btn btn-xs btn-dark" href="javascript:void(0)" title="Desactivar" onclick="desactivar(' . $value->id . ')"><i class="fa fa-power-off"></i></a> ';
                } else {
                    $boton .= '<a class="btn btn-xs btn-default" title="Activar" onclick="activar(' . $value->id . ')"><i class="fa fa-check"></i></a> ';
                }
            } else {
                if ($value->perfil <> 1) {
                    $boton .= '<a class="btn btn-xs btn-danger" href="javascript:void(0)" title="Modificar" onclick="edit(' . $value->id . ')"><i class="fa fa-pencil"></i></a> ';
                    $boton .= '<a class="btn btn-xs btn-primary" href="javascript:void(0)" title="Borrar" onclick="borrar(' . $value->id . ')"><i class="fa fa-trash"></i></a> ';
                    if ($value->estado == '0') {
                        $boton .= '<a class="btn btn-xs btn-dark" href="javascript:void(0)" title="Desactivar" onclick="desactivar(' . $value->id . ')"><i class="fa fa-power-off"></i></a> ';
                    } else {
                        $boton .= '<a class="btn btn-xs btn-default"  title="Activar" onclick="activar(' . $value->id . ')"><i class="fa fa-check"></i></a> ';
                    }
                }
            }
            $data[] = array(
                $key + 1,
                $value->documento,
                $value->apellido . ', ' . $value->nombre,
                $value->usuario,
                $perfil->nombre,
                $estado[$value->estado],
                $boton
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $start,
            "recordsFiltered" => $length,
            "data" => $data
        );
        //output to json format
        echo json_encode($result);
    }

    public function consulta_reniec()
    {
        if ($this->input->is_ajax_request()) {
            $consulta = file_get_html('https://eldni.com/buscar-por-dni?dni=' . $this->input->post('documento'));
            $partes = array();
            foreach ($consulta->find('td') as $header) {
                $partes[] = $header->plaintext;
            }
            $output = array("apellido" => $partes[1] . ' ' . $partes[2], "direccion" => '', 'nombre' => $partes[0]);
            $this->output->set_content_type('application/json')->set_output(json_encode($output));
        } else {
            show_404();
        }
    }

    private function _validate()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        // if (!$this->input->post('id')) {
        //     $usuario_dni = $this->db->where('documento', $this->input->post('documento'))->get('usuario')->row();
        //     if ($usuario_dni) {
        //         $data['inputerror'][] = 'documento';
        //         $data['error_string'][] = 'Este DNI. ya se encuentra registrado.';
        //         $data['status'] = FALSE;
        //     }
        //     $usuario_nick = $this->db->where('usuario', $this->input->post('usuario'))->get('usuario')->row();
        //     if ($usuario_nick) {
        //         $data['inputerror'][] = 'usuario';
        //         $data['error_string'][] = 'Este USUARIO. ya se encuentra registrado.';
        //         $data['status'] = FALSE;
        //     }
        // } else {
        //     $usuario_dni = $this->db->where('id', $this->input->post('id'))->get('usuario')->row();
        //     if ($usuario_dni) {
        //         if ($this->input->post('documento') != $usuario_dni->documento) {
        //             $usuario_dni2 = $this->db->where('documento', $this->input->post('documento'))->get('usuario')->row();
        //             if ($usuario_dni2) {
        //                 $data['inputerror'][] = 'documento';
        //                 $data['error_string'][] = 'Este DNI.. ya se encuentra registrado.';
        //                 $data['status'] = FALSE;
        //             }
        //         }
        //     }
        //     $usuario_nick = $this->db->where('usuario', $this->input->post('usuario'))->get('usuario')->row();
        //     if ($usuario_nick) {
        //         if ($this->input->post('usuario') != $usuario_nick->usuario) {
        //             $usuario_nick2 = $this->db->where('usuario', $this->input->post('usuario'))->get('usuario')->row();
        //             if ($usuario_nick2) {
        //                 $data['inputerror'][] = 'usuario';
        //                 $data['error_string'][] = 'Este USUARIO.. ya se encuentra registrado.';
        //                 $data['status'] = FALSE;
        //             }
        //         }
        //     }
        // }

        if ($this->input->post('documento') == '') {
            $data['inputerror'][] = 'documento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('usuario') == '') {
            $data['inputerror'][] = 'usuario';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('nacionalidad') == '') {
            $data['inputerror'][] = 'nacionalidad';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('nombre') == '') {
            $data['inputerror'][] = 'nombre';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('apellido') == '') {
            $data['inputerror'][] = 'apellido';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('sexo') == '') {
            $data['inputerror'][] = 'sexo';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('perfil') == '') {
            $data['inputerror'][] = 'perfil';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('id') == '') {
            if ($this->input->post('password') == '') {
                $data['inputerror'][] = 'password';
                $data['error_string'][] = 'Este campo es obligatorio.';
                $data['status'] = FALSE;
            }
        }

        if ($data['status'] === FALSE) {
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_add()
    {
        $this->_validate();
        $data['empresa'] = $this->empresa;
        $data['perfil'] = $this->input->post('perfil');
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['documento'] = $this->input->post('documento');
        $data['nacionalidad'] = $this->input->post('nacionalidad');
        $data['direccion'] = $this->input->post('direccion');
        $data['celular'] = $this->input->post('celular') != '' ? $this->input->post('celular') : '';
        $data['correo'] = $this->input->post('correo') != '' ? $this->input->post('correo') : '';
        $data['nacimiento'] = $this->input->post('nacimiento'); //$this->input->post('nacimiento') ? $this->input->post('nacimiento') : '1900-01-01';
        $data['sexo'] = $this->input->post('sexo');
        $data['usuario'] = $this->input->post('usuario');
        $data['imagen'] = 'sin_usuario.jpg';
        $data['password'] = hash('sha256', sha1($this->input->post('password')));
        if ($this->Controlador_model->save($this->controlador, $data)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_edit($id)
    {
        $data = $this->Controlador_model->get_by_id($id, $this->controlador);

        echo json_encode($data);
    }

    public function ajax_update()
    {
        $this->_validate();
        $data['perfil'] = $this->input->post('perfil');
        $data['documento'] = $this->input->post('documento');
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['nacimiento'] = $this->input->post('nacimiento'); // $this->input->post('nacimiento') ? $this->input->post('nacimiento') : '1900-01-01';
        $data['nacionalidad'] = $this->input->post('nacionalidad');
        $data['sexo'] = $this->input->post('sexo');
        $data['direccion'] = $this->input->post('direccion');
        $data['celular'] = $this->input->post('celular') != '' ? $this->input->post('celular') : '';
        $data['correo'] = $this->input->post('correo') != '' ? $this->input->post('correo') : '';
        $data['usuario'] = $this->input->post('usuario');
        if ($this->input->post('password')) {
            $data['password'] = hash('sha256', sha1($this->input->post('password')));
        }
        $this->Controlador_model->update(array('id' => $this->input->post('id')), $data, $this->controlador);
        echo json_encode(array("status" => TRUE, "data" => $data));
    }

    public function ajax_delete($id)
    {
        if ($this->Controlador_model->delete_by_id($id, $this->controlador)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_desactivar($id)
    {
        if ($this->Controlador_model->desactivar_by_id($id, $this->controlador)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_activar($id)
    {
        if ($this->Controlador_model->activar_by_id($id, $this->controlador)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_asistencia_presente($id)
    {
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_asistencia_tarde($id)
    {
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_asistencia_falta($id)
    {
        echo json_encode(array("status" => TRUE));
    }

    public function curso()
    {
        $periodoactual = $this->Controlador_model->periodoactual('1');
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'curso',
            'periodoid' => $periodoactual ? $periodoactual->id : 0,
            'periodoname' => $periodoactual ? $periodoactual->descripcion : '',
            'nivels' => $this->Controlador_model->getAll('nivel'),
            'periodos' => $this->Controlador_model->getallperiodo('1'),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_cursos()
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $periodo = $this->input->post('periodo');
        $grado = $this->input->post('grado');

        if ($this->perfil == 1) {
            if ($grado)
                $query = $this->db->where("periodo", $periodo)->where("grado", $grado)->order_by('id', 'desc')->get('docentecurso')->result();
            else
                $query = $this->db->where("periodo", $periodo)->order_by('id', 'desc')->get('docentecurso')->result();
        } else {
            if ($grado)
                $query = $this->db->where('docente', $this->usuario)->where("periodo", $periodo)->where("grado", $grado)->order_by('id', 'desc')->get('docentecurso')->result();
            else
                $query = $this->db->where('docente', $this->usuario)->where("periodo", $periodo)->order_by('id', 'desc')->get('docentecurso')->result();
        }
        $data = [];
        foreach ($query as $key => $value) {
            $grado = $this->Controlador_model->get($value->grado, 'grado');
            $nivel = $this->Controlador_model->get($grado->nivel, 'nivel');
            $curso = $this->Controlador_model->get($value->curso, 'curso');
            $seccion = $this->Controlador_model->get($value->seccion, 'seccion');
            $docente = $this->Controlador_model->get($value->docente, 'usuario');
            $categoria = $this->Controlador_model->get($curso->cursocategoria, 'cursocategoria');
            //add variables for action
            $boton = '';
            //add html fodr action
            $boton .= '<a class="btn btn-sm btn-warning" title="TEMAS" onclick="temas(' . $value->id . ')"><i class="fa fa-archive"></i></a> ';
            $data[] = array(
                $key + 1,
                $docente->apellido . ', ' . $docente->nombre,
                $categoria->nombre,
                $curso->nombre,
                $nivel->nombre,
                $grado->nombre,
                $seccion->nombre
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $start,
            "recordsFiltered" => $length,
            "data" => $data
        );
        //output to json format
        echo json_encode($result);
    }

    public function ajax_list_tema($id)
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $docente = $this->Controlador_model->get($id, 'usuariodocente');
        $query = $this->db->where('usuariodocente', $id)->order_by('id', 'desc')->get('usuariotema');
        $data = [];
        $no = 0;
        foreach ($query->result() as $value) {
            $no++;
            $dia = $this->Controlador_model->get($value->dia, 'dia');
            $semana = $this->Controlador_model->get($value->semana, 'semana');
            if ($value->estado == '0') {
                $estado = '<span class="label label-warning">PRIVADO</span>';
            }
            if ($value->estado == '1') {
                $estado = '<span class="label label-success">PUBLICO</span>';
            }
            //add variables for action
            $boton = '';
            //add html fodr action
            $boton .= '<a class="btn btn-sm btn-warning" href="javascript:void(0)" title="Descargar" href="' . $this->url . '/descargar/' . $value->id . '" target="_blank"><i class="fa fa-download"></i></a> ';
            $boton .= '<a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Borrar" onclick="borrartema(' . $value->id . ')"><i class="fa fa-trash"></i></a> ';
            if ($value->estado == '0') {
                $boton .= '<a class="btn btn-sm btn-inverse" href="javascript:void(0)" title="Publico" onclick="publico(' . $value->id . ')"><i class="fa fa-power-off"></i></a> ';
            } else {
                $boton .= '<a class="btn btn-sm btn-default" href="javascript:void(0)" title="Privado" onclick="privado(' . $value->id . ')"><i class="fa fa-check"></i></a> ';
            }
            $data[] = array(
                $no,
                $semana->nombre,
                $dia->nombre,
                $value->nombre,
                $value->archivo,
                $value->created,
                $estado,
                $boton
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $query->num_rows(),
            "recordsFiltered" => $query->num_rows(),
            "data" => $data
        );
        //output to json format
        echo json_encode($result);
    }

    private function _validate_tema()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;
        $producto = $this->Controlador_model->check_tema($this->input->post('nombre'));

        if ($producto) {
            $data['inputerror'][] = 'nombre';
            $data['error_string'][] = 'Este nombre ya se encuentra registrado.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('nombre') == '') {
            $data['inputerror'][] = 'nombre';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if (empty($_FILES['documento']['name'])) {
            $data['inputerror'][] = 'documento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($data['status'] === FALSE) {
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_add_tema()
    {
        $this->_validate_tema();
        $file_name = $_FILES['documento']['name'];
        $file_size = $_FILES['documento']['size'];
        $file_tmp = $_FILES['documento']['tmp_name'];
        $file_type = $_FILES['documento']['type'];
        $fp = fopen($file_tmp, 'r+b');
        $binario = fread($fp, filesize($file_tmp));
        fclose($fp);
        $docente = $this->Controlador_model->get($this->input->post('docentecurso'), 'usuariodocente');
        $data['empresa'] = $this->empresa;
        $data['periodo'] = $docente->periodo;
        $data['curso'] = $docente->curso;
        $data['usuario'] = $this->usuario;
        $data['semana'] = $this->input->post('semana');
        $data['dia'] = $this->input->post('dia');
        $data['usuariodocente'] = $this->input->post('docentecurso');
        $data['nombre'] = $this->input->post('nombre');
        $data['archivo'] = $_FILES['documento']['name'];
        $data['documento'] = $binario;
        $data['extension'] = $file_type;
        $data['peso'] = $file_size;
        $data['created'] = date('Y-m-d');
        if ($this->Controlador_model->save('usuariotema', $data)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_delete_tema($id)
    {
        $this->Controlador_model->delete_by_id($id, 'usuariotema');
        echo json_encode(array("status" => TRUE));
    }

    public function descargar($id)
    {
        $tema = $this->Controlador_model->get($id, 'usuariotema');
        header("Content-type: $tema->extension");
        header("Content-Disposition: inline; filename=$tema->archivo");
        print_r($tema->documento);
    }

    public function ajax_publico($id)
    {
        if ($this->Controlador_model->desactivar_by_id($id, 'usuariotema')) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_privado($id)
    {
        if ($this->Controlador_model->activar_by_id($id, 'usuariotema')) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function libros()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'libro',
            'periodo' => $this->Controlador_model->periodo(),
            'semanas' => $this->Controlador_model->getAll('semana'),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_alumno()
    {
        $ticket = '';
        $dias = $this->db->get('dia');
        $ticket .= '<table class="table table-striped">';
        foreach ($dias->result() as $value) {
            $ticket .= '<tr><th scope="row">' . $value->nombre . '</th></tr><tr><td>';
            $temas = $this->db->where('periodo', $this->input->post('periodo'))->where('semana', $this->input->post('semana'))->where('dia', $value->id)->get('usuariotema');
            foreach ($temas->result() as $value) {
                $curso = $this->Controlador_model->get($value->curso, 'curso');
                $ticket .= '<div class="col-md-6 col-sm-6 col-lg-3">
      <div class="mini-stat clearfix bx-shadow">
      <span class="mini-stat-icon bg-info"><i class="' . $curso->icon . '"></i></span>
      <div class="mini-stat-info text-right"><a href="' . $this->url . '/descargar/' . $value->id . '"><span>' . $curso->nombre . '</span>' . substr($value->nombre, 0, 15) . '</a></div>
      <div class="tiles-progress"><div class="m-t-20"><div class="progress progress-sm m-0">
      <div class="progress-bar progress-bar-info" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 10%;">
      </div></div></div></div></div></div>';
            }
            $ticket .= '</td></tr>';
        }
        $ticket .= '</table>';
        //output to json format
        echo $ticket;
    }

    public function completaralumno()
    {
        if (isset($_GET['term'])) {
            $q = strtoupper($_GET['term']);
            $this->Controlador_model->completaralumno($q);
        }
    }

    public function completarpariente()
    {
        if (isset($_GET['term'])) {
            $q = strtoupper($_GET['term']);
            $this->Controlador_model->completarpariente($q);
        }
    }

    public function ajax_updatealumno()
    {
        $datas = $this->db->where('usuario', $this->input->post('alumno'))->get('usuarioalumno')->first_row();
        if ($datas) {
            $docentes = $this->Controlador_model->get($datas->usuariodocente, 'usuariodocente');
            if ($docentes->grado == $this->input->post('grado') && $docentes->seccion == $this->input->post('seccion')) {
                if ($this->input->post('estado') == 1) {
                    $alumnos = $this->db->where('usuario', $this->input->post('alumno'))->where('curso', $this->input->post('curso'))->get('usuarioalumno')->row();
                    if ($this->Controlador_model->delete_by_id($alumnos->id, 'usuarioalumno')) {
                        echo json_encode(array("status" => TRUE));
                    }
                } else {
                    $data['empresa'] = $this->empresa;
                    $data['periodo'] = $this->input->post('periodo');
                    $data['usuario'] = $this->input->post('alumno');
                    $data['curso'] = $this->input->post('curso');
                    $data['usuariodocente'] = $this->input->post('usuariodocente');
                    if ($this->Controlador_model->save('usuarioalumno', $data)) {
                        echo json_encode(array("status" => TRUE));
                    }
                }
            } else {
                echo json_encode(array("status" => FALSE));
            }
        } else {
            if ($this->input->post('estado') == 1) {
                $alumnos = $this->db->where('usuario', $this->input->post('alumno'))->where('curso', $this->input->post('curso'))->get('usuarioalumno')->row();
                if ($this->Controlador_model->delete_by_id($alumnos->id, 'usuarioalumno')) {
                    echo json_encode(array("status" => TRUE));
                }
            } else {
                $data['empresa'] = $this->empresa;
                $data['periodo'] = $this->input->post('periodo');
                $data['usuario'] = $this->input->post('alumno');
                $data['curso'] = $this->input->post('curso');
                $data['usuariodocente'] = $this->input->post('usuariodocente');
                if ($this->Controlador_model->save('usuarioalumno', $data)) {
                    echo json_encode(array("status" => TRUE));
                }
            }
        }
    }

    public function asignarcursos2()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => 'asignarcursos2',
            'periodo' => $this->Controlador_model->get_periodo_tipo(2),
            'niveles' => $this->Controlador_model->get_nivel_tipo('2'),
            'secciones' => $this->Controlador_model->getAll('seccion'),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_asignarcurso2()
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $periodo = $this->input->post('periodo');
        $nivel = $this->input->post('nivel');
        $grado = $this->input->post('grado');
        $seccion = '1';
        if ($periodo && $nivel && $grado) {
            $query = $this->db->order_by('id', 'desc')->get('curso');
        } else {
            $query = $this->db->where('nombre', $periodo)->get('curso');
        }
        $data = [];
        $no = 0;
        foreach ($query->result() as $value) {
            $no++;
            $usuariodocente = $this->Controlador_model->docentecurso($value->id, $periodo, $grado, $seccion);
            $docentes = $this->db->where('perfil', 3)->order_by('id', 'desc')->get('usuario');
            //add variables for action
            $campo = '';
            $campo .= '<input type="hidden" id="curso' . $no . '" name="curso" value="' . $value->id . '">
    <select name="docente" id="docente' . $no . '" class="form-control" onchange="save(' . $no . ', ' . $periodo . ', ' . $nivel . ', ' . $grado . ', ' . $seccion . ')">
    <option value="">SELECCIONAR</option>';
            foreach ($docentes->result() as $docente) {
                if ($usuariodocente) {
                    $campo .= '<option value="' . $docente->id . '" ' . ($usuariodocente->usuario == $docente->id ? 'selected' : '') . '>' . $docente->documento . ' | ' . $docente->nombre . ' ' . $docente->apellido . '</option>';
                } else {
                    $campo .= '<option value="' . $docente->id . '">' . $docente->documento . ' | ' . $docente->nombre . ' ' . $docente->apellido . '</option>';
                }
            }
            $campo .= '</select>';
            $data[] = array(
                $no,
                $value->nombre,
                $campo
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $query->num_rows(),
            "recordsFiltered" => $query->num_rows(),
            "data" => $data
        );
        //output to json format
        echo json_encode($result);
    }

    public function alumnos()
    {
        $data = array(
            'titulo' => 'ALUMNOS', //$this->titulo_controlador,
            'contenido' => $this->vista,
            'perfil' =>  '4',
            'perfiles' => $this->Controlador_model->getAll('perfil'),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_alumnos()
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $query = $this->db->where('perfil', '4')->order_by('id', 'desc')->get($this->controlador);
        $data = [];
        $no = 0;
        foreach ($query->result() as $value) {
            $no++;
            if ($value->estado == '0') {
                $estado = '<span class="label label-success">ACTIVO</span>';
            }
            if ($value->estado == '1') {
                $estado = '<span class="label label-danger">DESABILITADO</span>';
            }
            //add variables for action
            $boton = '';
            //add html for action
            $boton .= '<a class="btn btn-sm btn-primary" title="Modificar" onclick="edit(' . "'" . $value->id . "'" . ')"><i class="fa fa-pencil"></i></a> ';
            $boton .= '<a class="btn btn-sm btn-danger" title="Borrar" onclick="borrar(' . "'" . $value->id . "'" . ')"><i class="fa fa-trash"></i></a> ';
            if ($value->estado == '0') {
                $boton .= '<a class="btn btn-sm btn-inverse" title="Desactivar" onclick="desactivar(' . "'" . $value->id . "'" . ')"><i class="fa fa-power-off"></i></a> ';
            } else {
                $boton .= '<a class="btn btn-sm btn-default" title="Activar" onclick="activar(' . "'" . $value->id . "'" . ')"><i class="fa fa-check"></i></a> ';
            }
            $data[] = array(
                $no,
                $value->documento,
                $value->apellido . ', ' . $value->nombre,
                $this->edad($value->nacimiento) . ' años',
                ($value->sexo == 0 ? 'M' : 'F'),
                $value->usuario,
                $estado,
                $boton
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $query->num_rows(),
            "recordsFiltered" => $query->num_rows(),
            "data" => $data
        );
        //output to json format
        echo json_encode($result);
    }

    function edad($fechanacimiento)
    {
        list($ano, $mes, $dia) = explode("-", $fechanacimiento);
        $ano_diferencia  = date("Y") - $ano;
        $mes_diferencia = date("m") - $mes;
        $dia_diferencia   = date("d") - $dia;
        if ($dia_diferencia < 0 || $mes_diferencia < 0)
            $ano_diferencia--;
        return $ano_diferencia;
    }

    private function _validate_alumnos()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if (!$this->input->post('id')) {
            $alumno_dni = $this->db->where('documento', $this->input->post('documento'))->get('usuario')->row();
            if ($alumno_dni) {
                $data['inputerror'][] = 'documento';
                $data['error_string'][] = 'Este DNI ya se encuentra registrado.';
                $data['status'] = FALSE;
            }
        } else {
            $alumno_dni = $this->db->where('id', $this->input->post('id'))->get('usuario')->row();
            if ($this->input->post('documento') != $alumno_dni->documento) {
                $alumno_dni2 = $this->db->where('documento', $this->input->post('documento'))->get('usuario')->row();
                if ($alumno_dni2) {
                    $data['inputerror'][] = 'documento';
                    $data['error_string'][] = 'Este DNI ya se encuentra registrado.';
                    $data['status'] = FALSE;
                }
            }
        }

        if ($this->input->post('documento') == '') {
            $data['inputerror'][] = 'documento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        } else {
            if (strlen($this->input->post('documento')) != 8) {
                $data['inputerror'][] = 'documento';
                $data['error_string'][] = 'Este campo necesita 8 digitos.';
                $data['status'] = FALSE;
            }
        }

        if ($this->input->post('nombre') == '') {
            $data['inputerror'][] = 'nombre';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('apellido') == '') {
            $data['inputerror'][] = 'apellido';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('nacimiento') == '') {
            $data['inputerror'][] = 'nacimiento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('celular') == '') {
            $data['inputerror'][] = 'celular';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('direccion') == '') {
            $data['inputerror'][] = 'direccion';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('nacionalidad') == '') {
            $data['inputerror'][] = 'nacionalidad';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('sexo') == '') {
            $data['inputerror'][] = 'sexo';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($data['status'] === FALSE) {
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_add_alumnos()
    {
        $this->_validate_alumnos();
        $data['empresa'] = $this->empresa;
        $data['perfil'] = "4";
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['documento'] = $this->input->post('documento');
        $data['direccion'] = $this->input->post('direccion');
        $data['celular'] = $this->input->post('celular');
        $data['correo'] = $this->input->post('correo');
        $data['nacimiento'] = $this->input->post('nacimiento');
        $data['sexo'] = $this->input->post('sexo');
        $data['nacionalidad'] = $this->input->post('nacionalidad');
        $data['usuario'] = $this->input->post('documento');
        $data['password'] = hash('sha256', sha1($this->input->post('documento')));
        if ($this->input->post('apoderado') != '')
            if ($this->input->post('pariente'))
                $data['pariente'] = $this->input->post('pariente');
        if ($this->Controlador_model->save($this->controlador, $data)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_update_alumnos()
    {
        $this->_validate_alumnos();
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['documento'] = $this->input->post('documento');
        $data['direccion'] = $this->input->post('direccion');
        $data['celular'] = $this->input->post('celular');
        $data['correo'] = $this->input->post('correo');
        $data['nacimiento'] = $this->input->post('nacimiento');
        $data['sexo'] = $this->input->post('sexo');
        $data['nacionalidad'] = $this->input->post('nacionalidad');
        if ($this->input->post('apoderado') != '') {
            if ($this->input->post('pariente'))
                $data['pariente'] = $this->input->post('pariente');
        } else {
            $data['pariente'] = NULL;
        }

        if ($this->Controlador_model->update(array('id' => $this->input->post('id')), $data, $this->controlador)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function cargardocente()
    {
        $datas = $this->db->where('perfil', '3')->get('usuario')->result();
        echo json_encode(array('docentes' => $datas));
    }

    public function alumnos_colegio_lista()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => 'alumno_colegio_lista',
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function cargarnivel()
    {
        $datas = $this->db->get('nivel')->result();
        echo json_encode(array('niveles' => $datas));
    }

    public function cargargrado($nivel)
    {
        $datas = $this->db->where('nivel', $nivel)->get('grado')->result();
        echo json_encode(array('grados' => $datas));
    }

    public function ajax_list_alumnos_colegio_lista()
    {
        $docente = $this->input->post('docente');
        $nivel = $this->input->post('nivel');
        $grado = $this->input->post('grado');
        $contenedor = '';
        if ($grado) {
            $grados = $this->Controlador_model->get($grado, 'grado');
            $contenedor .= $this->contenedor1($nivel, $grados);
        } else {
            // $grados = $this->Controlador_model->grados_docente_1($nivel, $this->usuario);
            $docentecuros = $this->Controlador_model->gradodocente($docente);
            foreach ($docentecuros as $key => $value) {
                if ($nivel) {
                    $grado = $this->Controlador_model->get($value->grado, 'grado');
                    $contenedor .= $this->contenedor1($nivel, $grado);
                }
            }
        }
        echo $contenedor;
    }

    public function contenedor1($periodo, $grado)
    {
        $nivel = $this->Controlador_model->get($grado->nivel, 'nivel');
        $query = $this->Controlador_model->alumnos_matricula_1($grado->id);
        $contenedor = '<div class="row"><div class="col-lg-12"><div class="card"><div class="card-body"><div class="input-group">
      <p class="mb-0">' . $nivel->nombre . ' ' . $grado->nombre . '
       : <span class="badge badge-pill badge-danger">' . $query->num_rows() . '</span> ALUMNOS</div></div></div></div></div>
      <div class="row">';
        foreach ($query->result() as $key => $value) {
            $arraynombre = explode(' ', $value->nombre);
            $contenedor .= '<div class="col-lg-6 col-xl-4"><div class="card"><div class="card-body"><div class="media">
          <a class="mr-3" href="' . base_url() . 'curso/poralumno/' . $value->id . '">
          <img class="avatar-md rounded-circle" src="' . base_url() . 'files/foto/' . $value->imagen . '" alt=""></a>
          <div class="media-body info align-self-center">
          <h5 class="font-16 mt-0 mb-1">' . $value->apellido . ', ' . $arraynombre[0] . '</h5>
          <p class="font-13 text-muted mb-0">Telefono: ' . $value->celular . '</p>
          <p class="font-13 text-muted mb-0">Correo: ' . $value->correo . '</p>
          </div></div></div></div></div>';
        }
        $contenedor .= '</div>';
        return $contenedor;
    }

    public function alumnos_academia_lista()
    {
        $tipo_operacion = 2;
        $periodo = $this->Controlador_model->periodo_1($tipo_operacion, date('Y'));
        $grados = NULL;
        if (!is_null($periodo))
            $grados = $this->Controlador_model->grados_docente_1($periodo->id, $this->usuario);
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => 'alumno_academia_lista',
            'perfiles' => $this->Controlador_model->getAll('perfil'),
            'periodo' => $periodo,
            'grados' => $grados,
            'tipo_operacion' => $tipo_operacion,
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_alumnos_academia_lista2()
    {
        $grado = $this->db->where('id', 13)->get('grado')->row();
        $contenedor = '';
        $contenedor .= $this->contenedor1($this->input->post('idperiodo'), $grado, 'primary');
        echo $contenedor;
    }

    public function miperfil()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->controlador . 'perfil',
            'usuario' => $this->Controlador_model->getconpariente($this->usuario),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    private function _validate_perfil()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if (!$this->input->post('id')) {
            $usuario_dni = $this->db->where('documento', $this->input->post('documento'))->get('usuario')->row();
            if ($usuario_dni) {
                $data['inputerror'][] = 'documento';
                $data['error_string'][] = 'Este DNI. ya se encuentra registrado.';
                $data['status'] = FALSE;
            }
            $usuario_nick = $this->db->where('usuario', $this->input->post('usuario'))->get('usuario')->row();
            if ($usuario_nick) {
                $data['inputerror'][] = 'usuario';
                $data['error_string'][] = 'Este USUARIO. ya se encuentra registrado.';
                $data['status'] = FALSE;
            }
        } else {
            $usuario_dni = $this->db->where('id', $this->input->post('id'))->get('usuario')->row();
            if ($usuario_dni) {
                if ($this->input->post('documento') != $usuario_dni->documento) {
                    $usuario_dni2 = $this->db->where('documento', $this->input->post('documento'))->get('usuario')->row();
                    if ($usuario_dni2) {
                        $data['inputerror'][] = 'documento';
                        $data['error_string'][] = 'Este DNI.. ya se encuentra registrado.';
                        $data['status'] = FALSE;
                    }
                }
            }
            $usuario_nick = $this->db->where('usuario', $this->input->post('usuario'))->get('usuario')->row();
            if ($usuario_nick) {
                if ($this->input->post('usuario') != $usuario_nick->usuario) {
                    $usuario_nick2 = $this->db->where('usuario', $this->input->post('usuario'))->get('usuario')->row();
                    if ($usuario_nick2) {
                        $data['inputerror'][] = 'usuario';
                        $data['error_string'][] = 'Este USUARIO.. ya se encuentra registrado.';
                        $data['status'] = FALSE;
                    }
                }
            }
        }
        if ($this->input->post('nombre') == '') {
            $data['inputerror'][] = 'nombre';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('apellido') == '') {
            $data['inputerror'][] = 'apellido';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('nacimiento') == '') {
            $data['inputerror'][] = 'nacimiento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('sexo') == '') {
            $data['inputerror'][] = 'sexo';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($data['status'] === FALSE) {
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_update_perfil()
    {
        $this->_validate_perfil();
        $data['nacionalidad'] = $this->input->post('nacionalidad');
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['documento'] = $this->input->post('documento');
        $data['direccion'] = $this->input->post('direccion');
        $data['celular'] = $this->input->post('celular');
        $data['correo'] = $this->input->post('correo');
        $data['nacimiento'] = $this->input->post('nacimiento');
        $data['sexo'] = $this->input->post('sexo');
        $data['usuario'] = $this->input->post('usuario');
        if ($this->perfil == 3) {
            $data['especialidad'] = $this->input->post('especialidad');
        }
        if ($this->perfil == 4) {
            if ($this->input->post('apoderado') == '')
                $data['pariente'] = NULL;
            else
                $data['pariente'] = $this->input->post('pariente');
        }
        if ($this->Controlador_model->update(array('id' => $this->input->post('id')), $data, $this->controlador))
            echo json_encode(array("status" => TRUE, 'msn' => 'El registro fue actualizado exitosamente.'));
        else
            echo json_encode(array("status" => TRUE, 'msn' => 'No hubo cambios.'));
    }

    public function asistenciacolegio()
    {
        $periodo = $this->Controlador_model->get_periodo_tipo(1);
        $grados = NULL;
        if (!is_null($periodo))
            $grados = $this->Controlador_model->grados_docente_1($periodo->id, $this->usuario);
        $seccion = $this->db->get('seccion')->result();
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => 'asistenciacolegio',
            'periodo' => $periodo,
            'grados' => $grados,
            'secciones' => $seccion,
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_asistencia_colegio()
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $query = $this->Controlador_model->alumnos_matricula_1($this->input->post('idperiodo'), $this->input->post('idgrado'));
        $data = [];
        $no = 0;
        foreach ($query->result() as $value) {
            $no++;
            $opciones = '';
            $opciones .= '
                <div class="form-group">
                    <label class="radio-inline">
                        <input type="radio" name="options' . $value->id . '" id="option1" value="1" onclick="presente(' . $value->id . ')" checked>PRESENTE
                    </label>
                    <label class="radio-inline">
                        <input type="radio" name="options' . $value->id . '" id="option2" value="2" onclick="tarde(' . $value->id . ')">TARDE
                    </label>
                    <label class="radio-inline">
                        <input type="radio" name="options' . $value->id . '" id="option3" value="3" onclick="falta(' . $value->id . ')">AUSENTE
                    </label>
                </div>';
            $data[] = array(
                $no,
                $value->apellido . ' ' . $value->apellido2 . ',' . $value->nombre,
                $opciones
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $query->num_rows(),
            "recordsFiltered" => $query->num_rows(),
            "data" => $data
        );
        //output to json format
        echo json_encode($result);
    }

    public function miclave()
    {
        $usuario = $this->db->where('id', $this->usuario)->get('usuario')->row();
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => 'miclave',
            'usuario' => $usuario,
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    private function _validate_clave()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if ($this->input->post('password') == '') {
            $data['inputerror'][] = 'password';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('password0') == '') {
            $data['inputerror'][] = 'password0';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        } else {
            $clave = hash('sha256', sha1($this->input->post('password0')));
            $usuario = $this->db->where('id', $this->usuario)->get('usuario')->row();
            if ($clave <> $usuario->password) {
                $data['inputerror'][] = 'password0';
                $data['error_string'][] = 'Contraseña actual incorrecta.';
                $data['status'] = FALSE;
            }
        }

        if ($this->input->post('password2') == '') {
            $data['inputerror'][] = 'password2';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        } else {
            if ($this->input->post('password') <> $this->input->post('password2')) {
                $data['inputerror'][] = 'password2';
                $data['error_string'][] = 'Este campo tiene que ser igual que Nueva contraseña.';
                $data['status'] = FALSE;
            }
        }

        if ($data['status'] === FALSE) {
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_update_clave()
    {
        $this->_validate_clave();
        $data['password'] = hash('sha256', sha1($this->input->post('password')));
        if ($this->Controlador_model->update(array('id' => $this->usuario), $data, $this->controlador)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function parientes()
    {
        $data = array(
            'titulo' => 'PARIENTES',
            'contenido' => $this->vista . 'pariente',
            'perfil' =>  '6',
            'periodo' => $this->Controlador_model->periodo(),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_parientes()
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $query = $this->db->where('perfil', '6')->order_by('id', 'desc')->get($this->controlador)->result();
        $data = [];
        $estado['0'] = '<span class="badge badge-success">ACTIVO</span>';
        $estado['1'] = '<span class="badge badge-danger">DESABILITADO</span>';
        foreach ($query as $key => $value) {
            $hijos = $this->Controlador_model->nrohijos($value->id);
            $boton = '';
            $boton .= '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="alumnos" onclick="hijos(' . $value->id . ')"><i class="fa fa-users"></i></a> ';
            $boton .= '<a class="btn btn-sm btn-warning" href="javascript:void(0)" title="Modificar" onclick="edit(' . $value->id . ')"><i class="fa fa-pencil"></i></a> ';
            $boton .= '<a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Borrar" onclick="borrar(' . $value->id . ')"><i class="fa fa-trash"></i></a> ';
            if ($value->estado == '0') {
                $boton .= '<a class="btn btn-sm btn-dark" href="javascript:void(0)" title="Desactivar" onclick="desactivar(' . $value->id . ')"><i class="fa fa-power-off"></i></a> ';
            } else {
                $boton .= '<a class="btn btn-sm btn-info" href="javascript:void(0)" title="Activar" onclick="activar(' . $value->id . ')"><i class="fa fa-check"></i></a> ';
            }
            $data[] = array(
                $key + 1,
                $value->documento,
                $value->apellido . ', ' . $value->nombre,
                $this->edad($value->nacimiento) . ' años',
                /* $value->sexo == 0 ? 'M' : 'F', */
                $value->especialidad == 'PAPA' ? 'PADRE' : ($value->especialidad == 'MAMA' ? 'MADRE' : ''),
                $hijos,
                $estado[$value->estado],
                $boton
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $start,
            "recordsFiltered" => $length,
            "data" => $data
        );
        echo json_encode($result);
    }

    public function ajax_list_hijos($pariente)
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));
        $periodo = $this->db->where('educacion', '0')->where('estado', '0')->get('periodo')->row();
        $query = $this->Controlador_model->nivel_grado($pariente);
        $data = [];
        foreach ($query as $key => $value) {
            $tipo = $this->Controlador_model->get($value->servicio, 'tipoperiodo');
            $data[] = array(
                $key + 1,
                $tipo->nombre,
                $value->documento,
                $value->nombre . ' ' . $value->apellido,
                $value->nivel_des,
                $value->grado_des //.' - '.$value->seccion_des
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $start,
            "recordsFiltered" => $length,
            "data" => $data
        );
        echo json_encode($result);
    }

    private function _validate_parientes()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if (!$this->input->post('id')) {
            $alumno_dni = $this->Controlador_model->buscarusuario($this->input->post('documento'), '6'); // $this->db->where('documento',$this->input->post('documento'))->get('usuario')->row();
            if ($alumno_dni) {
                $data['inputerror'][] = 'documento';
                $data['error_string'][] = 'Este DNI ya se encuentra registrado.';
                $data['status'] = FALSE;
            }
        } else {
            $alumno_dni = $this->db->where('id', $this->input->post('id'))->get('usuario')->row();
            if ($this->input->post('documento') != $alumno_dni->documento) {
                $alumno_dni2 = $this->Controlador_model->buscarusuario($this->input->post('documento'), '6'); //$this->db->where('documento',$this->input->post('documento'))->get('usuario')->row();
                if ($alumno_dni2) {
                    $data['inputerror'][] = 'documento';
                    $data['error_string'][] = 'Este DNI ya se encuentra registrado.';
                    $data['status'] = FALSE;
                }
            }
        }

        if ($this->input->post('documento') == '') {
            $data['inputerror'][] = 'documento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        } else {
            if (strlen($this->input->post('documento')) != 8) {
                $data['inputerror'][] = 'documento';
                $data['error_string'][] = 'Este campo necesita 8 digitos.';
                $data['status'] = FALSE;
            }
        }

        if ($this->input->post('documento') == '') {
            $data['inputerror'][] = 'documento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('nombre') == '') {
            $data['inputerror'][] = 'nombre';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('apellido') == '') {
            $data['inputerror'][] = 'apellido';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('nacimiento') == '') {
            $data['inputerror'][] = 'nacimiento';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('nacionalidad') == '') {
            $data['inputerror'][] = 'nacionalidad';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('direccion') == '') {
            $data['inputerror'][] = 'direccion';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('celular') == '') {
            $data['inputerror'][] = 'celular';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('sexo') == '') {
            $data['inputerror'][] = 'sexo';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('especialidad') == '') {
            $data['inputerror'][] = 'especialidad';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($data['status'] === FALSE) {
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_add_parientes()
    {
        $this->_validate_parientes();
        $data['empresa'] = $this->empresa;
        $data['perfil'] = "6";
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['documento'] = $this->input->post('documento');
        $data['direccion'] = $this->input->post('direccion');
        $data['celular'] = $this->input->post('celular');
        $data['correo'] = $this->input->post('correo');
        $data['nacimiento'] = $this->input->post('nacimiento');
        $data['sexo'] = $this->input->post('sexo');
        $data['nacionalidad'] = $this->input->post('nacionalidad');
        $data['especialidad'] = $this->input->post('especialidad');
        $data['usuario'] = $this->input->post('documento');
        $data['password'] = hash('sha256', sha1($this->input->post('documento')));
        if ($this->Controlador_model->save($this->controlador, $data)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function ajax_update_parientes()
    {
        $this->_validate_parientes();
        $data['nombre'] = $this->input->post('nombre');
        $data['apellido'] = $this->input->post('apellido');
        $data['documento'] = $this->input->post('documento');
        $data['direccion'] = $this->input->post('direccion');
        $data['celular'] = $this->input->post('celular');
        $data['correo'] = $this->input->post('correo');
        $data['nacimiento'] = $this->input->post('nacimiento');
        $data['especialidad'] = $this->input->post('especialidad');
        $data['sexo'] = $this->input->post('sexo');
        $data['nacionalidad'] = $this->input->post('nacionalidad');
        if ($this->Controlador_model->update(array('id' => $this->input->post('id')), $data, $this->controlador)) {
            echo json_encode(array("status" => TRUE));
        }
    }

    public function subir_archivo($archivo, $nombre)
    {
        $config["upload_path"] = "archivos/foto/";
        $config["file_name"] = $nombre;
        $config["allowed_types"] = "jpg|png|jpeg"; //"*"
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        if (!$this->upload->do_upload($archivo)) {
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function bajar_archivo($nombre_archivo)
    {
        $dir = base_url() . 'archivos/foto/' . $nombre_archivo;
        $fo = fopen($dir, 'r+b');
        $binario = fread($fo, filesize($fo));
        fclose($fo);
        header("Content-type: application/pdf");
        header("Content-Disposition: inline;filename=xxx.pdf");
        print_r($binario);
    }

    public function borrar_archivo($nombre_archivo)
    {
        $dir = 'archivos/foto/' . $nombre_archivo;
        if (strlen($nombre_archivo) > 0) {
            if (file_exists($dir)) {
                unlink($dir);
            }
        }
        return $dir;
    }

    public function ajax_grado_select()
    {
        $grado = $this->Controlador_model->getAll('grado');
        echo json_encode($grado);
    }

    public function ajax_nivel()
    {
        $nivel = $this->Controlador_model->get($this->input->post('nivel'), 'nivel');
        echo json_encode($nivel);
    }

    public function validate_curso()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;
        if ($this->input->post('periodo') == '0') {
            $data['inputerror'][] = 'periodo';
            $data['error_string'][] = 'Seleccion obligatoria';
            $data['status'] = FALSE;
        }
        if ($this->input->post('grado') == '0') {
            $data['inputerror'][] = 'grado';
            $data['error_string'][] = 'Seleccion obligatoria';
            $data['status'] = FALSE;
        }
        if ($this->input->post('seccion') == '0') {
            $data['inputerror'][] = 'seccion';
            $data['error_string'][] = 'Seleccion obligatoria';
            $data['status'] = FALSE;
        }
        if ($this->input->post('cursos') == '') {
            $data['inputerror'][] = 'cursos';
            $data['error_string'][] = 'Seleccion obligatoria';
            $data['status'] = FALSE;
        } else {
            $verif_nombre_curso = $this->db->where('nombre', $this->input->post('cursos'))->get('curso')->row();
            if ($this->input->post('cursos') == 'SIN RESULTADOS') {
                $data['inputerror'][] = 'cursos';
                $data['error_string'][] = 'Debe selecciona un curso';
                $data['status'] = FALSE;
            } else {
                $periodo = $this->input->post('periodo');
                $grado = $this->input->post('grado');
                $seccion =  $this->input->post('seccion');
                $curso = $this->input->post('curso');
                $query = $this->Controlador_model->queryvalidate($periodo, $grado, $seccion, $curso);
                if ($query) {
                    $data['inputerror'][] = 'cursos';
                    $data['error_string'][] = 'El curso ya esta asignado';
                    $data['status'] = FALSE;
                }
            }
        }

        if ($data['status'] === FALSE) {
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_agregar_curso()
    {
        $this->validate_curso();
        $data = [
            'periodo' => $this->input->post('periodo'),
            'grado' => $this->input->post('grado'),
            'seccion' => $this->input->post('seccion'),
            'docente' => $this->input->post('docente'),
            'curso' => $this->input->post('curso'),
        ];
        $insert = $this->Controlador_model->save('docentecurso', $data);
        if ($insert) {
            echo json_encode(['status' => TRUE]);
        }
    }

    function ajax_delete_docentecurso($id)
    {
        $delete = $this->Controlador_model->delete_by_id($id, 'docentecurso');
        if ($delete) {
            echo json_encode(['status' => TRUE]);
        }
    }
}
