<?php

class Seguimientoajuste extends CI_Controller
{

    public $semana = ['Domingo', 'Lunes', 'Martes', 'Miercoles', 'Jueves', 'Viernes', 'Sabado'];

    public function __construct()
    {
        parent::__construct();
        $this->load->model(modelo(), 'Controlador_model');
        $this->controlador =  controlador();
        $this->titulo_controlador = humanize($this->controlador);
        $this->url = base_url() . $this->controlador;
        $this->vista = $this->controlador;
        $this->perfil = $this->session->userdata('perfil') ? $this->session->userdata('perfil') : FALSE;
        $this->usuario = $this->session->userdata('usuario') ? $this->session->userdata('usuario') : FALSE;
        $this->empresa = $this->session->userdata('empresa') ? $this->session->userdata('empresa') : FALSE;
    }

    public function index()
    {
        $usuario = $this->Controlador_model->get($this->usuario, 'usuario');
        // $iiee = $this->Controlador_model->get($usuario->iiee_id, 'iiee');
        // $iiee = $this->db->where('usuario', $this->usuario)->get('iiee')->result();
        $this->db->select('ie.*');
        $this->db->join('asignariiee x', 'x.iiee=ie.id');
        $iiee = $this->db->where('x.usuario', $this->usuario)->get('iiee ie')->result();
        $data = array(
            'titulo' => $this->titulo_controlador,
            'iiee' => $iiee,
            // 'usuario' => $usuario,
            'contenido' => $this->vista,
            // 'xxx' => $this->controlador,
        );
        //  echo json_encode($data);
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function controlalumno()
    {
        $periodoactual = $this->Controlador_model->periodoactual('1');
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'controlalumno',
            'periodoid' => $periodoactual ? $periodoactual->id : 0,
            'periodoname' => $periodoactual ? $periodoactual->descripcion : '',
            'grados' => $this->Controlador_model->listargrados($this->perfil, $this->usuario),
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_controlalumno_datatable()
    {
        $draw = intval($this->input->get("draw"));
        $start = intval($this->input->get("start"));
        $length = intval($this->input->get("length"));

        $periodo = $this->input->post('periodo');
        $fecha = $this->input->post('fecha');
        //$nivel = $this->input->post('nivel');
        $turno = $this->input->post('turno');
        $grado = $this->input->post('grado');
        $seccion = $this->input->post('seccion');
        $hoy = date('Y-m-d');

        $query = $this->Controlador_model->listarmatricula($periodo, $grado, $seccion);
        $data = [];
        foreach ($query as $key => $value) {
            $checked = array('', '', '');
            $bloqueo = '';
            $asistencia = $query = $this->Controlador_model->buscarasistencia($value->mat, $turno, $fecha);
            if ($this->perfil == 3 && $fecha == $hoy) {
                $checked = array('checked', '', '');
            }
            if ($asistencia) {
                $checked[$asistencia->tipo] = 'checked';
            }
            if ($this->perfil <> 3) {
                $bloqueo = 'onclick="return false;"';
            }
            $opciones1 = '<input type="radio" name="options' . $key . '" title="PRESENTE" value="' . $value->mat . '_0_' . $value->id . '" ' . $checked[0] . ' ' . $bloqueo . ' />';
            $opciones2 = '<input type="radio" name="options' . $key . '" title="TARDE"    value="' . $value->mat . '_1_' . $value->id . '" ' . $checked[1] . ' ' . $bloqueo . ' />';
            $opciones3 = '<input type="radio" name="options' . $key . '" title="FALTA"    value="' . $value->mat . '_2_' . $value->id . '" ' . $checked[2] . ' ' . $bloqueo . ' />';
            $data[] = array(
                $key + 1,
                $value->apellido . ', ' . $value->nombre,
                $opciones1,
                $opciones2,
                $opciones3
            );
        }
        $result = array(
            "draw" => $draw,
            "recordsTotal" => $start,
            "recordsFiltered" => $length,
            "data" => $data
        );
        //output to json format
        echo json_encode($result);
    }

    public function ajax_list_controlalumno()
    {
        $periodo = $this->input->post('periodo');
        $fecha = $this->input->post('fecha');
        $turno = $this->input->post('turno');/* 0->maniana;1->tarde */
        $grado = $this->input->post('grado');
        $seccion = $this->input->post('seccion');
        $hoy = date('Y-m-d');

        $opciones = '';
        $query = $this->Controlador_model->listarmatricula($periodo, $grado, $seccion);
        $no = 0;
        $listados = 0;
        foreach ($query as $key => $value) {
            $checked = array('', '', '', '');
            $bloqueo = '';
            $opciones .= '<tr><td>' . ($no + 1) . '</td>';
            $opciones .= '<td>' . $value->apellido . ', ' . $value->nombre . '</td>';
            $asistencia = $this->Controlador_model->buscarasistencia($value->mat, $turno, $fecha);
            if ($fecha == $hoy) { //$this->perfil == 3 && 
                $checked = array('checked', '', '', '');
            }
            if ($asistencia) {
                $checked[$asistencia->tipo] = 'checked';
                $listados++;
            }
            /* if ($this->perfil <> 3) {
                $bloqueo = 'onclick="return false;"';
            } */
            $opciones .= '
      <td><input type="radio" name="options' . $no . '" title="PRESENTE" id="option1" value="' . $value->mat . '_0_' . $value->id . '" ' . $checked[0] . ' ' . $bloqueo . '/></td>
      <td><input type="radio" name="options' . $no . '" title="TARDE" id="option2" value="' . $value->mat . '_1_' . $value->id . '" ' . $checked[1] . ' ' . $bloqueo . '/></td>
      <td><input type="radio" name="options' . $no . '" title="FALTA" id="option3" value="' . $value->mat . '_2_' . $value->id . '" ' . $checked[2] . ' ' . $bloqueo . '/></td></tr>';
            $no = $key + 1;
        }
        $opciones .= '<tr style="display:none;"><td>sinerror<input type="text" name="nn" value="' . $no . '"/></td></tr>';
        //echo $opciones;
        echo json_encode(['opciones' => $opciones, 'listados' => $listados, 'btn' => $fecha == date('Y-m-d')]);
    }

    private function _validate_controlalumno()
    {
        $data = array();
        $data['error_string'] = array();
        $data['inputerror'] = array();
        $data['status'] = TRUE;

        if ($this->input->post('grado') == '') {
            $data['inputerror'][] = 'grado';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }

        if ($this->input->post('seccion') == '') {
            $data['inputerror'][] = 'seccion';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($this->input->post('turno') == '') {
            $data['inputerror'][] = 'turno';
            $data['error_string'][] = 'Este campo es obligatorio.';
            $data['status'] = FALSE;
        }
        if ($data['status'] === FALSE) {
            $data['msn'] = 'Falta seleccionar campos';
            echo json_encode($data);
            exit();
        }
    }

    public function ajax_update_controlalumno()
    {
        $this->_validate_controlalumno();
        $fecha = $this->input->post('fecha');
        /* $nivel = $this->input->post('nivel'); */
        /* $curso = $this->input->post('curso'); */
        $turno = $this->input->post('turno');
        /* $grado = $this->input->post('grado'); */
        /* $seccion = $this->input->post('seccion'); */

        $nn = $this->input->post('nn');
        if ($nn > 0) {
            //$docentecurso = $this->db->where('grado', $grado)->where('seccion', $seccion)->where('curso', $curso)->get('docentecurso')->row();
            /* $idprimero = FALSE;
            if ($this->input->post('options0')) {
                $opcion = explode('-', $this->input->post('options0'));
                $idprimero = $this->db->where('matricula', $opcion[0])->where('created', $fecha)->where('reg_primero', '1')->get($this->controlador)->row();
            } */
            for ($i = 0; $i < $nn; $i++) {
                $opcion = explode('_', $this->input->post('options' . $i)); //->where('docentecurso', $docentecurso->id)
                $asistencia = $this->Controlador_model->buscarasistencia($opcion[0], $turno, $fecha);
                //$this->db->where('matricula', $opcion[0])->where('created', $fecha)->get($this->controlador)->row();
                if ($asistencia) {
                    $asistencia->tipo = $opcion[1];
                    $this->Controlador_model->update('id=' . $asistencia->id, $asistencia, $this->controlador);
                } else {
                    $data = [];
                    $data['matricula'] = $opcion[0];
                    //$data['docentecurso'] = $docentecurso->id;
                    $data['alumno'] = $opcion[2];
                    $data['tipo'] = $opcion[1];
                    //$data['reg_primero'] = $idprimero ? '0' : '1';
                    $data['turno'] = $turno;
                    $data['usuario'] = $this->usuario;
                    $data['created'] = $fecha;
                    $this->Controlador_model->save($this->controlador, $data);
                }
            }
            echo json_encode(array('status' => TRUE, 'listados' => 1, 'msn' => 'Los registros fueron guardados correctamente.'));
        } else
            echo json_encode(array('status' => FALSE, 'listados' => 0, 'msn' => 'Error no hay registros seleccionados.'));
    }


    public function controldocente()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'controldocente',
            'periodos' => $this->Controlador_model->periodos(1),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_controldocente()
    {
        $periodo = $this->input->post('periodo');
        $turno = $this->input->post('turno');
        $fecha = $this->input->post('fecha');
        $hoy = date('Y-m-d');

        $opciones = '';
        $query = $this->Controlador_model->listardocentes($periodo);
        $no = 0;
        $listados = 0;
        foreach ($query as $key => $value) {
            $checked = array('', '', '', '');
            $bloqueo = '';
            $opciones .= '<tr><td>' . ($key + 1) . '</td>';
            $opciones .= '<td>' . $value->apellido . ', ' . $value->nombre . '</td>';
            $asistencia = $this->Controlador_model->buscarasistenciadocente($value->id, $turno, $fecha);
            if ($fecha == $hoy) $checked = array('checked', '', '', '');
            else  $bloqueo = 'onclick="return false;"';
            if ($asistencia) {
                $listados++;
                $checked[$asistencia->tipo] = 'checked';
            }
            $opciones .= '<td>
      <input type="radio" name="options' . $key . '" title="PRESENTE" value="' . $value->id . '_0' . '" ' . $checked[0] . ' ' . $bloqueo . '/></td><td>
      <input type="radio" name="options' . $key . '" title="TARDE"    value="' . $value->id . '_1' . '" ' . $checked[1] . ' ' . $bloqueo . '/></td><td>
      <input type="radio" name="options' . $key . '" title="FALTA"    value="' . $value->id . '_2' . '" ' . $checked[2] . ' ' . $bloqueo . '/></td></tr>';
            $no = $key + 1;
        }
        $opciones .= '<tr style="display:none;"><td>sinerror<input type="text" name="nn" value="' . $no . '"/></td></tr>';
        echo json_encode(['opciones' => $opciones, 'listados' => $listados, 'btn' => $fecha == date('Y-m-d')]);
    }

    public function ajax_update_controldocente()
    {
        $fecha = $this->input->post('fecha');
        $turno = $this->input->post('turno');
        $nn = $this->input->post('nn');
        if ($nn > 0) {
            for ($i = 0; $i < $nn; $i++) {
                $data = [];
                $opcion = explode('_', $this->input->post('options' . $i));
                $asistencia = $this->db->where('docente', $opcion[0])->where('created', $fecha)->get($this->controlador)->row();
                if ($asistencia) {
                    $data['tipo'] = $opcion[1];
                    $this->Controlador_model->update('id=' . $asistencia->id, $data, $this->controlador);
                } else {
                    $data['docente'] = $opcion[0];
                    $data['tipo'] = $opcion[1];
                    $data['turno'] = $turno;
                    //$data['reg_primero'] = '1';
                    $data['usuario'] = $this->usuario;
                    $data['created'] = $fecha;
                    $this->Controlador_model->save($this->controlador, $data);
                }
            }
            echo json_encode(array('status' => TRUE, 'msn' => 'Los registros fueron guardados correctamente.'));
        } else
            echo json_encode(array('status' => FALSE, 'msn' => 'Error no hay registros seleccionados.', 'nn' => $nn));
    }

    public function consultaalumno()
    {
        $periodoactual = $this->Controlador_model->periodoactual('1');
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'consultaalumno',
            'periodoid' => $periodoactual ? $periodoactual->id : 0,
            'periodoname' => $periodoactual ? $periodoactual->descripcion : '',
            'alumno' => $this->Controlador_model->get($this->usuario, 'usuario'),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_consultaalumno()
    {
        $semana = array('Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab', 'Dom');
        $periodo = $this->input->post('periodo');
        $mes = $this->input->post('mes');
        $alumno = $this->perfil == 4 ? $this->usuario : $this->input->post('alumno');
        $rangofechas = $this->listaFechaCompletaporMes($mes, date('Y'));
        $no = 0;

        $cab = '<tr class="bg-primary text-white"><th  style="font-size:60%;">Turno</th>';
        foreach ($rangofechas as $value) {
            $ff = explode('-', $value);
            $cab .= '<th style="font-size:60%;">' . $semana[date('N', strtotime($value)) - 1] . '<br>' . $ff[2] . '</th>';
        }
        $cab .= '<th style="font-size:60%;">Presente</th><th style="font-size:60%;">Tarde</th><th style="font-size:60%;">Falta</th></tr>';

        $bod = '';

        $turnos = [0, 1];

        $matricula = $this->db->where('periodo', $periodo)->where('alumno', $alumno)->get('matricula')->row();
        foreach ($turnos as $key => $tt) {
            $est_P = 0;
            $est_T = 0;
            $est_F = 0;
            $est_FJ = 0;

            $bod .= '<tr style="font-size:80%;">';
            $asis = '<td style="font-size:80%;">' . ($tt == 0 ? 'Mañana' : 'Tarde') . '</td>';

            foreach ($rangofechas as $fecha) {
                $valasis = $this->db->where('matricula', $matricula->id)->where('turno', $tt)->where('created', $fecha)->get('asistencia')->row();
                if ($valasis) {
                    if ($valasis->tipo == 0) {
                        $asis .= '<td><button type="button" class="btn btn-success btn-xs p-1">P</button></td>';
                        $est_P++;
                    }
                    if ($valasis->tipo == 1) {
                        $asis .= '<td><button type="button" class="btn btn-warning btn-xs p-1">T</button></td>';
                        $est_T++;
                    }
                    if ($valasis->tipo == 2) {
                        $asis .= '<td><button type="button" class="btn btn-primary btn-xs p-1">F</button></td>';
                        $est_F++;
                    }
                    if ($valasis->tipo == 3) {
                        $asis .= '<td><button type="button" class="btn btn-primary btn-xs p-1">FJ</button></td>';
                        $est_FJ++;
                    }
                } else $asis .= '<td></td>';
            }
            $bod .= $asis . '<td><button type="button" class="btn btn-success btn-xs p-1">' . $est_P . '</button></td>
                       <td><button type="button" class="btn btn-warning btn-xs p-1">' . $est_T . '</button></td>
                       <td><button type="button" class="btn btn-primary btn-xs p-1">' . $est_F . '</button></td></tr>';
        }


        /* $opciones = '<div class="row"><div class="col-lg-12"><div class="card"><div class="card-header">
        <h3 class="card-title text-dark">LISTA DE ASISTENCIA.</h3></div><div class="card-body table-responsive">
        
        <div class="table-responsive">
        <table id="tabla" class="table table-striped table-bordered dt-responsive nowrap m-0" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
        <thead>' . $cab . '</thead><tbody>' . $bod . '</tbody></table></div>
        </div></div></div>'; */

        //echo $opciones;
        echo json_encode(['head' => $cab, 'body' => $bod]);
    }


    public function controldiario()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'controldiario',
            'alumno' => $this->Controlador_model->get($this->usuario, 'usuario'),
            'breads' => array(array('ruta' => 'javascript:;', 'titulo' => $this->titulo_controlador))
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }


    public function ajax_list_controldiario()
    {
        $periodo = $this->input->post('periodo'); //no recibe esto :0
        $fecha = $this->input->post('fecha');
        $alumno = $this->input->post('alumno');
        $no = 0;

        $cab = '<tr><th>CURSO</th><th>DOCENTE</th>';
        $cab .= '<th>ASISTENCIA</th></tr>';
        $mat = $this->db->where('alumno', $alumno)->get('matricula')->row();
        $cursos = $this->Controlador_model->listarcurso($periodo, $mat->grado, $mat->seccion, $this->perfil, null);
        $bod = '';
        $fondo = array('#31FC40', '#EEF549', '#FC3131');
        //$estado=array('PRESENTE','TARDE','FALTA','FALTA JUSTIFICADA');
        $estado = array(
            '<button type="button" class="btn btn-success btn-xs p-1">P</button>',
            '<button type="button" class="btn btn-warning btn-xs p-1">T</button>',
            '<button type="button" class="btn btn-danger btn-xs p-1">F</button>', 'FALTA JUSTIFICADA'
        );
        foreach ($cursos as $key => $curso) {
            //if($curso->nombre=="COMPORTAMIENTO")continue;
            $docente = $this->Controlador_model->buscardocentecurso($mat->grado, $mat->seccion, $curso->id);
            $asis = $this->db->where('matricula', $mat->id)->where('docentecurso', $docente->id)->where('alumno', $mat->alumno)->where('created', $fecha)->get('asistencia')->row();

            if ($asis) {
                $bod .= '<tr><td>' . $curso->nombre . '</td><td>' . $docente->apellido . ', ' . $docente->nombre . '</td>';
                $bod .= '<td><div style="color:' . $fondo[$asis->tipo] . ';font-weight:bold">' . $estado[$asis->tipo] . '</td></tr>';
            }
        }

        $opciones = '<div class="row"><div class="col-lg-12"><div class="card"><div class="card-header">
        <h3 class="card-title text-dark">LISTA DE ASISTENCIA.</h3></div><div class="card-body table-responsive">
        <table id="tabla" class="table table-striped table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
        <thead>' . $cab . '</thead><tbody>' . $bod . '</tbody></table></div></div></div>';

        echo $opciones;
    }


    public function listaFechaCompletaporMes($mes, $ano)
    {
        $nrodias = date('t', strtotime($ano . '-' . ($mes < 10 ? '0' . $mes : $mes) . '-01'));
        $fechas = array();
        for ($i = 0; $i < $nrodias; $i++) {
            $dia = $i + 1;
            $fecha = $ano . '-' . ($mes < 10 ? '0' . $mes : $mes) . '-' . ($dia < 10 ? '0' . $dia : $dia);
            $numdia = date('N', strtotime($fecha));
            if ($numdia != 6 && $numdia != 7)
                $fechas[] = $fecha;
        }
        return $fechas;
    }

    public function cargargradoauxiliar($auxiliar)
    {
        $this->db->join('auxiliarasignado v2', 'v2.id=v1.auxiliarasignado');
        $this->db->join('grado v3', 'v3.id=v1.grado');
        $this->db->join('nivel v4', 'v4.id=v3.nivel');
        $this->db->where('v2.usuario', $auxiliar);
        $this->db->distinct();
        $this->db->select('v3.id,v3.nombre grado,v4.nombre nivel');
        $gradosx = $this->db->get('auxiliaraulas v1')->result();

        echo json_encode(array('grados' => $gradosx));
    }

    public function cargarseccionauxiliar($auxiliar, $grado)
    {
        $this->db->join('auxiliarasignado v2', 'v2.id=v1.auxiliarasignado');
        $this->db->join('seccion v3', 'v3.id=v1.seccion');
        $this->db->where('v2.usuario', $auxiliar);
        $this->db->where('v1.grado', $grado);
        $this->db->select('v3.id,v3.nombre');
        $seccion = $this->db->get('auxiliaraulas v1')->result();

        echo json_encode(array('seccions' => $seccion));
    }

    public function cargar___seccion()
    {
        echo json_encode(array('secciones' => $this->Controlador_model->listarseccion($this->input->post('grado'))));
    }
    public function cargarcurso()
    {
        echo json_encode(array('cursos' => $this->Controlador_model->listarcurso($this->input->post('periodo'), $this->input->post('grado'), $this->input->post('seccion'), $this->perfil, $this->usuario)));
    }
    public function cargaralumno()
    {
        echo json_encode(array('alumnos' => $this->Controlador_model->listaralumnos($this->input->post('usuario'))));
    }

    public function buscardocente()
    {
        echo json_encode(array('docente' => $this->Controlador_model->buscardocente($this->input->post('grado'), $this->input->post('seccion'), $this->input->post('curso'))));
    }
    public function buscarmatricula()
    {
        echo json_encode(array('matricula' => $this->Controlador_model->buscarmatricula($this->input->post('periodo'), $this->input->post('alumno'))));
    }

    public function completaralumno($periodo)
    {
        if (isset($_GET['term'])) {
            $q = strtoupper($_GET['term']);
            $this->Controlador_model->completaralumno($q, $periodo);
        }
    }

    public function consultamensual()
    {
        $periodoactual = $this->Controlador_model->periodoactual('1');
        $this->db->where('v1.periodo', $periodoactual->id);
        $this->db->where('v2.estado', '0');
        $this->db->join('usuario v2', 'v2.id=v1.usuario');
        $this->db->select('v2.*');
        $aux = $this->db->get('auxiliarasignado v1')->result();
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'consultamensual',
            'periodoid' => $periodoactual ? $periodoactual->id : 0,
            'periodoname' => $periodoactual ? $periodoactual->descripcion : '',
            'auxiliars' => $aux,
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_consultamensual()
    {
        $semana = array('Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab', 'Dom');
        $periodo = $this->input->post('periodo');
        $turno = $this->input->post('turno');
        $mes = $this->input->post('mes');
        $auxiliar = $this->input->post('auxiliar');
        $rangofechas = $this->listaFechaCompletaporMes($mes, date('Y'));

        $cab = '<tr class="bg-primary text-white"><th>#</th><th>Aula</th>';
        foreach ($rangofechas as $value) {
            $ff = explode('-', $value);
            $cab .= '<th style="font-size:60%;">' . $semana[date('N', strtotime($value)) - 1] . '<br>' . $ff[2] . '</th>';
        }
        $cab .= '</tr>';
        if ($auxiliar != 0) {
            $this->db->join('auxiliarasignado v2', 'v2.id=v1.auxiliarasignado');
            $this->db->join('grado v3', 'v3.id=v1.grado');
            $this->db->join('seccion v4', 'v4.id=v1.seccion');
            $this->db->join('nivel v5', 'v5.id=v3.nivel');
            $this->db->where('v2.usuario', $auxiliar);
            $this->db->select('v3.id grado,v3.nombre ngrado,v4.id seccion,v4.nombre nseccion,v5.id nivel,v5.nombre nnivel');
            $this->db->order_by('v1.grado', 'asc');
            $this->db->order_by('v1.seccion', 'asc');
            $aulas = $this->db->get('auxiliaraulas v1')->result();
        } else {
            $this->db->join('grado v2', 'v2.id=v1.grado');
            $this->db->join('seccion v3', 'v3.id=v1.seccion');
            $this->db->join('nivel v4', 'v4.id=v2.nivel');
            $this->db->select('v2.id grado,v2.nombre ngrado,v3.id seccion,v3.nombre nseccion,v4.id nivel,v4.nombre nnivel');
            $this->db->distinct();
            $this->db->where('v1.periodo', $periodo);
            $this->db->order_by('v2.id', 'asc');
            $this->db->order_by('v3.id', 'asc');
            $aulas = $this->db->get('matricula v1')->result();
        }
        $bod = '';
        foreach ($aulas as $key => $value) {
            $bod .= '<tr><td>' . ($key + 1) . '</td><td><span  style="float:left;">' . $value->ngrado . ' ' . $value->nseccion . '</span></td>';
            foreach ($rangofechas as $fecha) {
                $this->db->where('v2.grado', $value->grado);
                $this->db->where('v2.seccion', $value->seccion);
                $this->db->where('v1.turno', $turno);
                $this->db->where('v1.created', $fecha);
                $this->db->join('matricula v2', 'v2.id=v1.matricula');
                $valasis = $this->db->get('asistencia v1')->result();
                if ($valasis) $bod .= '<td><i class="fa fa-check-square-o btn-danger"></i></td>';
                else $bod .= '<td></td>';
            }
            $bod .= '</tr>';
        }
        echo json_encode(['head' => $cab, 'body' => $bod, 'v2' => $aulas]);
    }

    public function docentemensual()
    {
        $periodoactual = $this->Controlador_model->periodoactual('1');
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'docentemensual',
            'periodoid' => $periodoactual ? $periodoactual->id : 0,
            'periodoname' => $periodoactual ? $periodoactual->descripcion : '',
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_docentemensual()
    {
        $semana = array('Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab', 'Dom');
        $periodo = $this->input->post('periodo');
        $turno = $this->input->post('turno');
        $mes = $this->input->post('mes');
        $rangofechas = $this->listaFechaCompletaporMes($mes, date('Y'));

        $cab = '<tr class="bg-primary text-white"><th>#</th><th>Docente</th>';
        foreach ($rangofechas as $value) {
            $ff = explode('-', $value);
            $cab .= '<th style="font-size:60%;">' . $semana[date('N', strtotime($value)) - 1] . '<br>' . $ff[2] . '</th>';
        }
        $cab .= '<th>P</th><th>T</th><th>F</th></tr>';

        $this->db->join('usuario v2', 'v2.id=v1.docente');
        $this->db->select('v2.*');
        $this->db->where('v1.periodo', $periodo);
        $this->db->where('v2.estado', '0');
        //$this->db->order_by('v2.nombre', 'asc');
        $this->db->order_by('v2.apellido', 'asc');
        $aulas = $this->db->get('docenteasignado v1')->result();
        $estado = array(
            '<button type="button" class="btn btn-success btn-xs p-1">P</button>',
            '<button type="button" class="btn btn-warning btn-xs p-1">T</button>',
            '<button type="button" class="btn btn-danger btn-xs p-1">F</button>', 'FALTA JUSTIFICADA'
        );
        $bod = '';

        foreach ($aulas as $key => $value) {
            $pp = 0;
            $tt = 0;
            $ff = 0;
            $bod .= '<tr><td>' . ($key + 1) . '</td><td><span  style="float:left;">' . $value->apellido . ', ' . $value->nombre . '</span></td>';
            foreach ($rangofechas as $fecha) {
                $this->db->where('docente', $value->id);
                $this->db->where('turno', $turno);
                $this->db->where('created', $fecha);
                $valasis = $this->db->get('asistencia')->row();
                if ($valasis) {
                    $bod .= '<td>' . $estado[$valasis->tipo] . '</td>';
                    $pp += $valasis->tipo == 0 ? 1 : 0;
                    $tt += $valasis->tipo == 1 ? 1 : 0;
                    $ff += $valasis->tipo == 2 ? 1 : 0;
                } else $bod .= '<td></td>';
            }
            $bod .= '<td><button type="button" class="btn btn-success btn-xs p-1">' . $pp . '</button></td>
            <td><button type="button" class="btn btn-warning btn-xs p-1">' . $tt . '</button></td>
            <td><button type="button" class="btn btn-danger btn-xs p-1">' . $ff . '</button></td></tr>';
        }
        echo json_encode(['head' => $cab, 'body' => $bod]);
    }

    public function alumnomensual()
    {
        $periodoactual = $this->Controlador_model->periodoactual('1');
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'alumnomensual',
            'periodoid' => $periodoactual ? $periodoactual->id : 0,
            'periodoname' => $periodoactual ? $periodoactual->descripcion : '',
            'grados' => $this->Controlador_model->listargrados($this->perfil, $this->usuario),
        );
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_alumnomensual()
    {
        $semana = array('Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab', 'Dom');
        $periodo = $this->input->post('periodo');
        $grado = $this->input->post('grado');
        $seccion = $this->input->post('seccion');
        $turno = $this->input->post('turno');
        $mes = $this->input->post('mes');
        $rangofechas = $this->listaFechaCompletaporMes($mes, date('Y'));

        $cab = '<tr class="bg-primary text-white"><th>#</th><th>Alumnos</th>';
        foreach ($rangofechas as $value) {
            $ff = explode('-', $value);
            $cab .= '<th style="font-size:60%;">' . $semana[date('N', strtotime($value)) - 1] . '<br>' . $ff[2] . '</th>';
        }
        $cab .= '<th>P</th><th>T</th><th>F</th></tr>';

        $this->db->join('usuario v2', 'v2.id=v1.alumno');
        $this->db->select('v2.*,v1.id matricula');
        $this->db->where('v1.periodo', $periodo);
        $this->db->where('v1.grado', $grado);
        $this->db->where('v1.seccion', $seccion);
        $this->db->order_by('v2.apellido', 'asc');
        $aulas = $this->db->get('matricula v1')->result();

        $estado = array(
            '<button type="button" class="btn btn-success btn-xs p-1">P</button>',
            '<button type="button" class="btn btn-warning btn-xs p-1">T</button>',
            '<button type="button" class="btn btn-danger btn-xs p-1">F</button>', 'FALTA JUSTIFICADA'
        );
        $bod = '';

        foreach ($aulas as $key => $value) {
            $pp = 0;
            $tt = 0;
            $ff = 0;
            $bod .= '<tr><td>' . ($key + 1) . '</td><td><span  style="float:left;">' . $value->apellido . ', ' . $value->nombre . '</span></td>';
            foreach ($rangofechas as $fecha) {
                $this->db->where('matricula', $value->matricula);
                $this->db->where('turno', $turno);
                $this->db->where('created', $fecha);
                $valasis = $this->db->get('asistencia')->row();
                if ($valasis) {
                    $bod .= '<td>' . $estado[$valasis->tipo] . '</td>';
                    $pp += $valasis->tipo == 0 ? 1 : 0;
                    $tt += $valasis->tipo == 1 ? 1 : 0;
                    $ff += $valasis->tipo == 2 ? 1 : 0;
                } else $bod .= '<td></td>';
            }
            $bod .= '<td><button type="button" class="btn btn-success btn-xs p-1">' . $pp . '</button></td>
            <td><button type="button" class="btn btn-warning btn-xs p-1">' . $tt . '</button></td>
            <td><button type="button" class="btn btn-danger btn-xs p-1">' . $ff . '</button></td></tr>';
        }
        echo json_encode(['head' => $cab, 'body' => $bod]);
    }

    // nuevos

    // public function cargariiee($docente)
    // {
    //     $this->db->where('usuario.id', $docente);
    //     $this->db->select('iiee.*');
    //     $this->db->join('usuario', 'usuario.iiee_id=iiee.id');
    //     $iiees = $this->db->get('iiee')->result();

    //     echo json_encode(array('iiees' => $iiees));
    // }

    public function cargargrado($iiee)
    {
        $this->db->where('iiee.id', $iiee);
        $this->db->distinct();
        $this->db->select('grado.*');
        $this->db->join('iiee', 'iiee.id=aa.iiee_id');
        $this->db->join('grado', 'grado.id=aa.grado');
        $grados = $this->db->order_by('grado.grado')->get('alumno aa')->result();

        echo json_encode(array('grados' => $grados));
    }

    // public function cargarseccion($iiee, $grado)
    // {
    //     $this->db->where('iiee.id', $iiee);//->where('aa.grado', $grado);
    //     $this->db->distinct();
    //     $this->db->select('seccion.*');
    //     $this->db->join('iiee', 'iiee.id=aa.iiee_id');
    //     $this->db->join('seccion', 'seccion.id=aa.seccion');
    //     $seccion = $this->db->order_by('seccion.seccion')->get('alumno aa')->result();

    //     echo json_encode(array('seccions' => $seccion));
    // }

    public function cargarseccion($iiee)
    {
        $this->db->where('iiee_id', $iiee); //->where('aa.grado', $grado);
        $this->db->distinct();
        $this->db->select('dsc_seccion seccion');
        // $this->db->join('iiee', 'iiee.id=aa.iiee_id');
        //$this->db->join('seccion', 'seccion.id=aa.seccion');
        $seccion = $this->db->order_by('dsc_seccion')->get('alumno aa')->result();

        echo json_encode(array('seccions' => $seccion));
    }

    public function pruebas()
    {
        //domingo   =>0
        //lunes     =>1
        //martes    =>2
        echo date('w', strtotime(date('Y-m-d'))) . '<BR>';
        echo date('w', strtotime('2024-03-18')) . '<BR>';
        echo date('w', strtotime('2024-03-19')) . '<BR>';
        echo date('w', strtotime('2024-03-20')) . '<BR>';
        echo date('w', strtotime('2024-03-21')) . '<BR>';
        echo date('w', strtotime('2024-03-22')) . '<BR>';
        echo date('w', strtotime('2024-03-23')) . '<BR>';
        echo date('w', strtotime('2024-03-24')) . '<BR>';
        echo date('Y-m-d day -1') . '<BR>';

        echo date('Y-m-d', strtotime("-1 days", strtotime(date('Y-m-d')))) . '<BR>';
        echo date('Y-m-d', strtotime("-2 days", strtotime(date('Y-m-d')))) . '<BR>';
        echo date('Y-m-d', strtotime("-3 days", strtotime(date('Y-m-d')))) . '<BR>';
    }

    public function ajax_list_seguidos()
    {
        $iiee = $this->input->post('iiee');
        $grado = $this->input->post('grado');
        $seccion = $this->input->post('seccion');
        $fechai = $this->input->post('fechai');
        $fechaf = $this->input->post('fechaf');

        $se = date('w', strtotime(date('Y-m-d')));
        // $this->db->where('iiee_id', $iiee)->where('grado', $grado)->where('seccion', $seccion);
        // $datatotal = $this->db->order_by('apellido_paterno')->get('alumno aa')->result();
        $this->db->where('iiee_id', $iiee)->where('dsc_seccion', $seccion); //->where('anemia', 'SI');//->where('grado', $grado)->where('seccion', $seccion)
        $data = $this->db->order_by('nombres')->get('alumno aa')->result();

        #semana evaluada
        // if ($se == 1) {
        //     $fechas[0] = date('Y-m-d', strtotime("-2 days", strtotime(date('Y-m-d'))));
        //     $fechas[1] = date('Y-m-d', strtotime("-1 days", strtotime(date('Y-m-d'))));
        //     $fechas[2] = date('Y-m-d');
        // } else {
        //     $fechas[0] = date('Y-m-d');
        // }

        $fechas = $this->getRangeDate($fechai, $fechaf);

        $html = '<thead><tr>
                    <th>#</th>
                    <th>Alumno</th>
                    <th>Fecha Dosaje</th>
                    <th>Hemoglobina</th>
                    <th>Anemia</th>';
        foreach ($fechas as $key => $ff) {
            $html .= '<th>' . date('y', strtotime($ff)) . '<br>' . date('m', strtotime($ff)) . '<br>' . date('d', strtotime($ff)) . '</th>';
        }
        // foreach ($fechas as $fec) {
        //     $html .= '<th>Evaluacion[<input type="checkbox" checked> SI <input type="checkbox"> NO]<br>' . $this->semana[date('w', strtotime($fec))] . ' ' . date('d/m/Y', strtotime($fec)) . '</th>';
        // }
        $html .= '</tr></thead><tbody>';
        foreach ($data as $key => $value) {
            $ha = '<input type="hidden" name="alumno' . $key . '" id="alumno' . $key . '" value="' . $value->id . '"  />';

            //<td>' . $ha . ($key + 1) . '</td><td>' . $value->apellido_paterno . ' ' . $value->apellido_materno . ', ' . $value->nombres . '</td>
            $html .= '<tr>
            <td>' . $ha . ($key + 1) . '</td><td>' . $value->nombres . '</td>
            <td align=center>' . ($value->hemoglobina == '-' ? '-' : date('d/m/Y', strtotime($value->fecha_dosaje))) . '</td>
            <td align=center>' .  $value->hemoglobina . '</td>
            <td align=center>' . $value->anemia . '</td>
            ';
            foreach ($fechas as $keyfec => $fec) {

                $seguimiento = $this->db->where(['alumno' => $value->id, 'usuario' => $this->usuario, 'fecha_registro' => $fec])->get('seguimiento')->row();
                if ($seguimiento) {
                    $checked = $seguimiento->estado == 'SI' ? 'checked' : '';
                    $motivo = $seguimiento->motivo ? $seguimiento->motivo : '';
                    $estado = $seguimiento->estado == 'SI' ? 'SI' : 'NO';
                } else {
                    $checked = 'checked';
                    $motivo = '';
                    $estado = 'SI';
                }
                $opcion = '';
                $opcion .= '<table style="width:100%" border="0" cellspacing="0" cellpadding="0"><tr><td width="30%">';
                $opcion .= '<input type="checkbox" name="options' . $key . '_' . $keyfec . '" id="options' . $key . '_' . $keyfec . '"  onclick="cambiarSINO(' . $key . ',' . $keyfec . ')" title="seguimiento" value="' . $value->id . '_' . $iiee . '" ' . $checked . '/>';
                $opcion .= '<label for="options' . $key . '_' . $keyfec . '">' . $estado . '<label>';
                $opcion .= '</td><td>';
                $opcion .= '<input type="text" name="motivo' . $key . '_' . $keyfec . '" value="' . $motivo . '" placeholder="Ingrese Motivo"/>';
                $opcion .= '</td></tr></table>';
                $html .= '<td>' . $opcion . '</td>';
            }
            $html .= '</tr></tbody>';
        }
        // echo json_encode(array('lista' => $data));
        // echo $html; 
        echo json_encode(['html' => $html, 'conteo' => count($data), 'conteofec' => count($fechas)]);
    }

    // public function ajax_list_seguidos()
    // {
    //     $iiee = $this->input->post('iiee');
    //     $grado = $this->input->post('grado');
    //     $seccion = $this->input->post('seccion');
    //     $se = date('w', strtotime(date('Y-m-d')));
    //     $this->db->where('iiee_id', $iiee)->where('grado', $grado)->where('seccion', $seccion);
    //     $data = $this->db->order_by('apellido_paterno')->get('alumno aa')->result();
    //     if ($se == 0) {
    //     } else {
    //     }
    //     $html = '';
    //     foreach ($data as $key => $value) {
    //         $opcion = '<input type="hidden" name="alumno' . $key . '" id="alumno' . $key . '" value="' . $value->id . '"  />';

    //         $seguimiento = $this->db->where(['alumno' => $value->id, 'usuario' => $this->usuario, 'fecha_registro' => date('Y-m-d')])->get('seguimiento')->row();
    //         if ($seguimiento) {
    //             $checked = $seguimiento->estado == 'SI' ? 'checked' : '';
    //             $motivo = $seguimiento->motivo ? $seguimiento->motivo : '';
    //             $estado = $seguimiento->estado == 'SI' ? 'SI' : 'NO';
    //         } else {
    //             $checked = 'checked';
    //             $motivo = '';
    //             $estado = 'SI';
    //         }
    //         $opcion .= '<table style="width:100%" border="0" cellspacing="0" cellpadding="0"><tr><td width="30%">';
    //         $opcion .= '<input type="checkbox" name="options' . $key . '" id="options' . $key . '"  onclick="cambiarSINO(' . $key . ')" title="seguimiento" value="' . $value->id . '_' . $iiee . '_' . $grado . '_' . $seccion . '" ' . $checked . '/>';
    //         $opcion .= '<label for="options' . $key . '">' . $estado . '<label>';
    //         $opcion .= '</td><td>';
    //         $opcion .= '<input type="text" name="motivo' . $key . '" value="' . $motivo . '" placeholder="Ingrese Motivo"/>';
    //         $opcion .= '</td></tr></table>';

    //         $html .= '<tr>
    //         <td>' . ($key + 1) . '</td><td>' . $value->apellido_paterno . ' ' . $value->apellido_materno . ', ' . $value->nombres . '</td>
    //         <td>' . date('d/m/Y', strtotime($value->fecha_dosaje)) . '</td>
    //         <td>' . $opcion . '</td>
    //         </tr>';
    //     }
    //     // echo json_encode(array('lista' => $data));
    //     // echo $html; 
    //     echo json_encode(['html' => $html, 'conteo' => count($data)]);
    // }

    public function ajax_save_seguimiento()
    {
        $conteo = $this->input->post('conteo');
        $conteo2 = $this->input->post('conteo2');
        $fechai = $this->input->post('fechaix');
        $fechaf = $this->input->post('fechafx');
        // $fechas = [];
        // if ($conteo2 == 3) {
        //     $fechas[0] = date('Y-m-d', strtotime("-2 days", strtotime(date('Y-m-d'))));
        //     $fechas[1] = date('Y-m-d', strtotime("-1 days", strtotime(date('Y-m-d'))));
        //     $fechas[2] = date('Y-m-d');
        // } else {
        //     $fechas[0] = date('Y-m-d');
        // }
        $fechas = $this->getRangeDate($fechai, $fechaf);

        $xx = [];
        for ($i = 0; $i < $conteo; $i++) {
            $alumnoid = $this->input->post('alumno' . $i);
            $alumno = $this->Controlador_model->get($alumnoid, 'alumno');
            foreach ($fechas as $keyfec => $fec) {
                $seguimiento = $this->db->where(['alumno' => $alumnoid, 'usuario' => $this->usuario, 'fecha_registro' => $fec])->get('seguimiento')->row();
                if ($seguimiento) {
                    $this->Controlador_model->update(
                        ['id' => $seguimiento->id],
                        [
                            'estado' => $this->input->post('options' . $i . '_' . $keyfec) ? 'SI' : 'NO',
                            'motivo' => $this->input->post('motivo' . $i . '_' . $keyfec) != '' ? $this->input->post('motivo' . $i . '_' . $keyfec) : NULL
                        ],
                        'seguimiento'
                    );
                } else {
                    $data['alumno'] = $alumnoid;
                    $data['usuario'] = $this->usuario;
                    $data['fecha_dosaje'] = $alumno->fecha_dosaje;
                    $data['fecha_seguimiento'] = date('Y-m-d');
                    $data['fecha_registro'] = $fec;
                    $data['estado'] = $this->input->post('options' . $i . '_' . $keyfec) ? 'SI' : 'NO';
                    $data['motivo'] = $this->input->post('motivo' . $i . '_' . $keyfec) != '' ? $this->input->post('motivo' . $i . '_' . $keyfec) : NULL;
                    $this->Controlador_model->save('seguimiento', $data);
                }
            }
            // $xx[] = $data;
            // $xx[] = $this->input->post('options' . $i . '_' . $keyfec) . '  options' . $i . '_' . $keyfec . '   ' . count($fechas).'  '.$conteo2;
        }

        echo json_encode(['status' => TRUE, 'conteo' => $xx]);
    }

    public function ajax_evaluar_save()
    {
        $iiee = $this->input->post('iiee');
        $grado = $this->input->post('grado');
        $seccion = $this->input->post('seccion');

        $seguimiento = $this->db->where(['ss.usuario' => $this->usuario, 'ss.fecha_registro' => date('Y-m-d')])
            ->where(['aa.iiee_id' => $iiee]) //'aa.grado' => $grado, 'aa.seccion' => $seccion,
            ->join('alumno aa', 'aa.id=ss.alumno')->get('seguimiento ss')->result();
        if (count($seguimiento) > 0)
            echo json_encode(['status' => TRUE, 'conteo' => TRUE]);
        else
            echo json_encode(['status' => FALSE, 'conteo' => FALSE]);
    }

    public function reporte()
    {
        $data = array(
            'titulo' => $this->titulo_controlador,
            'contenido' => $this->vista . 'reporte',
            // 'docentes' => $this->db->select('id,nombre,apellido,documento')->where('perfil', 3)->order_by('apellido')->get('usuario')->result(),
            'iiees' => $this->db->select('id,nombre_ie,cod_mod')->order_by('nombre_ie')->get('iiee')->result(),
        );
        // echo json_encode($data);
        $this->load->view(THEME . TEMPLATE, $data);
    }

    public function ajax_list_reporte_seguidos()
    {
        $fechai = $this->input->post('fechai');
        $fechaf = $this->input->post('fechaf');
        $iiee = $this->input->post('iiee');
        $grado = $this->input->post('grado');
        $seccion = $this->input->post('seccion');
        // $docente = $this->db->where('iiee_id', $iiee)->get('usuario')->row();
        $iiee2 = $this->db->where('id', $iiee)->get('iiee')->row();
        $docente = $this->Controlador_model->get($iiee2->usuario, 'usuario');
        $this->db->where('iiee_id', $iiee)->where('dsc_seccion', $seccion); //->where('anemia', 'SI');//->where('grado', $grado)->where('seccion', $seccion)
        $data = $this->db->order_by('nombres')->get('alumno aa')->result();

        $fechas = $this->getRangeDate($fechai, $fechaf);
        $html = '<thead>
        <tr>
          <th>#</th>
          <th>Alumno</th>
          <th>Fecha Dosaje</th>
          <th>Hemoglobina</th>
          <th>Anemia</th>
          ';
        foreach ($fechas as $key => $ff) {
            $dia = date('w', strtotime($ff));
            /* if ($dia > 0 && $dia < 6) */
            $html .= '<th>' . date('y', strtotime($ff)) . '<br>' . date('m', strtotime($ff)) . '<br>' . date('d', strtotime($ff)) . '</th>';
        }
        $html .= '</tr>
      </thead>
      <tbody>';
        foreach ($data as $key => $value) {
            //<button type="button" class="btn btn-warning btn-xs btn-sm p-1 text-danger" onclick=""><i class="fa fa-bar-chart"></i></button>
            $html .= '<tr>';
            $html .= '<td>' . ($key + 1) . '</td>';
            $html .= '<td>' . $value->nombres . '</td>'; //$value->apellido_paterno . ' ' . $value->apellido_materno . ', ' . 
            $html .= '<td>' . date('d/m/y', strtotime($value->fecha_dosaje)) . '</td>';
            $html .= '<td align=center>' .  $value->hemoglobina . '</td>';
            $html .= '<td align=center>' . $value->anemia . '</td>';

            foreach ($fechas as $key => $ff) {
                $dia = date('w', strtotime($ff));
                /* if ($dia > 0 && $dia < 6) { */
                $seguimiento = $this->db->where(['alumno' => $value->id, 'usuario' => $docente->id, 'fecha_registro' => $ff])->get('seguimiento')->row();
                if ($seguimiento) {
                    if ($seguimiento->estado == 'SI') {
                        if ($seguimiento->motivo) {
                            $btn = '<th><button type="button" class="btn btn-danger btn-xs btn-sm p-1" onclick="abrirmsn(' . $seguimiento->id . ',`' . $seguimiento->motivo . '`,`SI`)"><del>SI</del></button></th>';
                        } else {
                            $btn = '<th><button type="button" class="btn btn-danger btn-xs btn-sm p-1">SI</button></th>';
                        }
                    } else {
                        if ($seguimiento->motivo) {
                            $btn = '<th><button type="button" class="btn btn-primary btn-xs btn-sm p-0"  onclick="abrirmsn(' . $seguimiento->id . ',`' . $seguimiento->motivo . '`,`NO`)"><del>NO</del></button></th>';
                        } else {
                            $btn = '<th><button type="button" class="btn btn-primary btn-xs btn-sm p-0">NO</button></th>';
                        }
                    }
                    $html .= $btn; //$seguimiento->estado == 'SI' ?'<th><button type="button" class="btn btn-danger btn-xs btn-sm p-1" onclick="abrirmsn(' . $seguimiento->id . ',`' . $seguimiento->motivo . '`,`SI`)">SI</button></th>' :'<th><button type="button" class="btn btn-primary btn-xs btn-sm p-0"  onclick="abrirmsn(' . $seguimiento->id . ',`' . $seguimiento->motivo . '`,`NO`)">NO</button></th>';
                } else {
                    $html .= '<th></th>';
                }
                /* } */
            }
            $html .= '</tr>';
        }

        $html .= '</tbody>';
        // echo json_encode(array('lista' => $data));
        // echo $html; 
        echo json_encode(['html' => $html]);
    }

    public function listaFechaCompletaporMesx($mes, $ano)
    {
        $nrodias = date('t', strtotime($ano . '-' . ($mes < 10 ? '0' . $mes : $mes) . '-01'));
        $fechas = array();
        for ($i = 0; $i < $nrodias; $i++) {
            $dia = $i + 1;
            $fecha = $ano . '-' . ($mes < 10 ? '0' . $mes : $mes) . '-' . ($dia < 10 ? '0' . $dia : $dia);
            $numdia = date('N', strtotime($fecha));
            if ($numdia != 6 && $numdia != 7)
                $fechas[] = $fecha;
        }
        echo json_encode($fechas);
    }

    function getRangeDate($date_ini = '2024-01-01', $date_end = '2024-03-01')
    { //'2021-01-01', '2021-03-31', 'Y-m-d'
        $format = 'Y-m-d';
        $dt_ini = DateTime::createFromFormat($format, $date_ini);
        $dt_end = DateTime::createFromFormat($format, $date_end);
        $period = new DatePeriod(
            $dt_ini,
            new DateInterval('P1D'),
            $dt_end,
        );
        $range = [];
        foreach ($period as $date) {
            $range[] = $date->format($format);
        }
        $range[] = $date_end;
        return $range;
        // echo json_encode($range);
    }

    function getRangeDatex($date_ini = '2024-01-01', $date_end = '2024-03-01')
    { //'2021-01-01', '2021-03-31', 'Y-m-d'
        $format = 'Y-m-d';
        $dt_ini = DateTime::createFromFormat($format, $date_ini);
        $dt_end = DateTime::createFromFormat($format, $date_end);
        $period = new DatePeriod(
            $dt_ini,
            new DateInterval('P1D'),
            $dt_end,
        );
        $range = [];
        foreach ($period as $date) {
            $range[] = $date->format($format);
        }
        $range[] = $date_end;
        // return $range;
        echo json_encode($range);
    }

    public function ajax_grafica_seguimiento()
    {
        $fechai = $this->input->post('fechai');
        $fechaf = $this->input->post('fechaf');
        $iiee = $this->input->post('iiee');
        $grado = $this->input->post('grado');
        $seccion = $this->input->post('seccion');

        $fechas = $this->getRangeDate($fechai, $fechaf);


        $this->db->where("ss.fecha_registro between '$fechai' and '$fechaf'");
        $this->db->where('aa.grado', $grado);
        // if ($seccion) $this->db->where('aa.seccion', $seccion);
        $this->db->where('aa.iiee_id', $iiee);
        $this->db->join('alumno aa', 'aa.id=ss.alumno')->select('ss.fecha_registro')->select('sum(if(ss.estado="SI",1,0)) as conteo,sum(if(ss.estado="NO",1,0)) as conteo2', false);
        $seguimiento = $this->db->group_by('fecha_registro')->get('seguimiento ss')->result();
        $x = [];
        $y = [];
        $z = [];
        foreach ($seguimiento as $key => $value) {
            $x[] = date('d/m/y', strtotime($value->fecha_registro));
            $y[] = $value->conteo;
            $z[] = $value->conteo2;
        }


        echo json_encode(['status' => TRUE, 'data' => $seguimiento, 'x' => $x, 'y' => $y, 'z' => $z]);
    }
}
