<?php

class Inicio extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    $this->load->model(modelo(), 'Controlador_model');
    $this->controlador = controlador();
    $this->titulo_controlador = humanize($this->controlador);
    $this->url = base_url() . $this->controlador;
    $this->vista = $this->controlador;
    $this->perfil = $this->session->userdata('perfil') ? $this->session->userdata('perfil') : FALSE;
    $this->usuario = $this->session->userdata('usuario') ? $this->session->userdata('usuario') : FALSE;
    $this->empresa = $this->session->userdata('empresa') ? $this->session->userdata('empresa') : FALSE;
  }

  public function index()
  {
    $alumno = $this->db->query("SELECT count(id) alumnos,sum(if(anemia='SI',1,0)) sanemicos,sum(if(anemia!='SI' or anemia is null,1,0)) nanemicos FROM `alumno`")->row();
    $pronoei = $this->db->query("SELECT count(*) total FROM `iiee`")->row();
    $data = array(
      'titulo' => $this->titulo_controlador,
      'contenido' => $this->vista,
      'usuarios' => $this->Controlador_model->numeros('usuario'),
      'alumno' => $alumno,
      'pronoei' => $pronoei,
    );
    $this->load->view(THEME . TEMPLATE, $data);
  }

  public function ajax_list()
  {
    $draw = intval($this->input->get("draw"));
    $start = intval($this->input->get("start"));
    $length = intval($this->input->get("length"));
    $query = $this->db->where('empresa', $this->empresa)->order_by('id', 'desc')->get('periodo');
    $data = [];
    $no = 0;
    foreach ($query->result() as $value) {
      $no++;
      //add variables for action
      $data[] = array(
        $no,
        $value->periodo,
        $value->descripcion,
        $value->created,
        '<span class="label label-danger">COMPRAR</span>'
      );
    }
    $result = array(
      "draw" => $draw,
      "recordsTotal" => $query->num_rows(),
      "recordsFiltered" => $query->num_rows(),
      "data" => $data
    );
    //output to json format
    echo json_encode($result);
  }

  public function ajax_buscar_alumno($id)
  {
    $data = $this->db->where('id', $id)->get('usuario')->row();
    echo json_encode($data);
  }

  public function buscarperiodogrado()
  {
    echo json_encode(array('periodogrado' => $this->Controlador_model->buscarperiodogrado($this->usuario)));
  }

  public function buscarperiodogrado2()
  {
    echo json_encode(array('periodogrado' => $this->Controlador_model->periodo('0')));
  }

  public function ajax_list_miscursos()
  {
    $mat = $this->Controlador_model->getmatricula($this->usuario);
    $vista = '';
    $vas = 0;
    foreach ($this->Controlador_model->allcursosalumno($mat->periodo, $mat->grado, $mat->seccion) as $key => $value) {
      if ($vas == 0) $vista .= '<div class="row">';
      $vista .= $this->card1($value);
      if ($vas == 2) $vista .= '</div>';
      $vas++;
      if ($vas == 3) $vas = 0;
    }
    echo $vista;
  }

  public function card1($curso)
  {
    $tarjeta = '';
    $imagen = $curso->imagen == '' ? 'sin_usuario.jpg' : $curso->imagen;
    $tarjeta .= '<div class="col-lg-6 col-xl-4"><div class="card"><div class="card-body">
    <div class="media"><a class="mr-3" href="#">
    <img class="avatar-md rounded-circle" src="' . base_url() . 'files/curso/' . $imagen . '" alt=""></a>
    <div class="info" ><h5><b style="font-size:14px;">' . $curso->nombre . '</b></h5>
    <p class="text-muted"><span style="font-size:10px;"><i class="fa fa-user-secret"></i> ' . $curso->apellido . ', ' . $curso->nombred . '</span></p>
    </div></div></div></div></div>';
    return $tarjeta;
  }

  public function ajax_list_mishijos()
  {
    $periodo = $this->input->post('periodo');
    $hijos = $this->Controlador_model->listaralumnos($periodo, $this->usuario);
    $vista = '';
    $vas = 0;
    foreach ($hijos as $key => $value) {
      $vista .= $this->card2($value);
    }
    /*foreach ($this->Controlador_model->allcursosalumno($mat->periodo,$mat->grado,$mat->seccion) as $key => $value) {
      if($vas==0)$vista.='<div class="col-md-12">';
      $vista.=$this->card1($value);
      if($vas==2)$vista.='</div>';
      $vas++;
      if($vas==3)$vas=0;
    }*/
    echo $vista;
  }

  public function card2($alumno)
  {
    $tarjeta = '';
    $tarjeta .= '
    <div class="col-lg-6 col-xl-4">
      <div class="card">
        <div class="card-body">
          <div class="media">
            <a class="mr-3" href="#">
              <img class="avatar-md rounded-circle" src="' . base_url() . 'files/foto/sin_usuario.jpg" alt="">
            </a>
            <div class="media-body info align-self-center">
              <h5 class="font-12 mt-0 mb-1">' . $alumno->nombre . ', ' . $alumno->apellido . '</h5>
              <!--p class="font-11 text-muted mb-0">
                <span><i class="fa fa-graduation-cap"></i> ' . $alumno->gradon . '</span>
              </p-->
              <p class="font-12 text-muted mb-0"><!--i class="fa fa-volume-control-phone"></i-->' . ($alumno->celular != '' ? $alumno->celular : 'SIN TELEFONO') . '</p>
              <p class="font-12 text-muted mb-0"><!--i class="fa fa-address-card"></i--> ' . ($alumno->correo != '' ? $alumno->correo : 'SIN CORREO') . '</p>
              <p class="font-12 text-muted mb-0"><!--i class="fa fa-graduation-cap"></i--> ' . $alumno->gradon . '</p>
            </div>
          </div>
        </div>
      </div>
    </div>';
    return $tarjeta;
  }

  public function getyearstatsingreso($year)
  {
    $usuario = $this->perfil == 4 ? $this->usuario : FALSE;
    $enero = $this->Controlador_model->grafico($usuario, '1', $year, 'ingreso');
    $febrero = $this->Controlador_model->grafico($usuario, '2', $year, 'ingreso');
    $marzo = $this->Controlador_model->grafico($usuario, '3', $year, 'ingreso');
    $abril = $this->Controlador_model->grafico($usuario, '4', $year, 'ingreso');
    $mayo = $this->Controlador_model->grafico($usuario, '5', $year, 'ingreso');
    $junio = $this->Controlador_model->grafico($usuario, '6', $year, 'ingreso');
    $julio = $this->Controlador_model->grafico($usuario, '7', $year, 'ingreso');
    $agosto = $this->Controlador_model->grafico($usuario, '8', $year, 'ingreso');
    $setiembre = $this->Controlador_model->grafico($usuario, '9', $year, 'ingreso');
    $octubre = $this->Controlador_model->grafico($usuario, '10', $year, 'ingreso');
    $noviembre = $this->Controlador_model->grafico($usuario, '11', $year, 'ingreso');
    $diciembre = $this->Controlador_model->grafico($usuario, '12', $year, 'ingreso');
    $result = "";
    $result .= '<script type="text/javascript">$(document).ready(function() {Highcharts.chart("graficoingreso", {chart: {type: "column"},
    title: {text: "REPORTE MENSUAL DEl ' . $year . '"},xAxis: {
      categories: ["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Set","Oct","Nov","Dic"],crosshair: true},yAxis:
    {min: 0,title: {text: "Dinero (S/)"}},tooltip: {headerFormat: "<table>",pointFormat: "';
    $result .= "<tr><td style='padding:0'><b>S/ {point.y:.2f}</b></td></tr>";
    $result .= '",footerFormat: "</table>",shared: true,useHTML: true},plotOptions: {column: {pointPadding: 0.20,borderWidth: 0}}
    ,series: [{name: "INGRESO", data: [' . (isset($enero->monto) ? $enero->monto : 0) . ',' . (isset($febrero->monto) ? $febrero->monto : 0) . '
    ,' . (isset($marzo->monto) ? $marzo->monto : 0) . ',' . (isset($abril->monto) ? $abril->monto : 0) . '
    ,' . (isset($mayo->monto) ? $mayo->monto : 0) . ',' . (isset($junio->monto) ? $junio->monto : 0) . '
    ,' . (isset($julio->monto) ? $julio->monto : 0) . ',' . (isset($agosto->monto) ? $agosto->monto : 0) . '
    ,' . (isset($setiembre->monto) ? $setiembre->monto : 0) . ',' . (isset($octubre->monto) ? $octubre->monto : 0) . '
    ,' . (isset($noviembre->monto) ? $noviembre->monto : 0) . ',' . (isset($ventadic->monto) ? $ventadic->monto : 0) . ']}]});});</script>';
    echo $result;
  }

  public function getyearstatsegreso($year)
  {
    $usuario = $this->perfil == 4 ? $this->usuario : FALSE;
    $enero = $this->Controlador_model->grafico($usuario, '1', $year, 'egreso');
    $febrero = $this->Controlador_model->grafico($usuario, '2', $year, 'egreso');
    $marzo = $this->Controlador_model->grafico($usuario, '3', $year, 'egreso');
    $abril = $this->Controlador_model->grafico($usuario, '4', $year, 'egreso');
    $mayo = $this->Controlador_model->grafico($usuario, '5', $year, 'egreso');
    $junio = $this->Controlador_model->grafico($usuario, '6', $year, 'egreso');
    $julio = $this->Controlador_model->grafico($usuario, '7', $year, 'egreso');
    $agosto = $this->Controlador_model->grafico($usuario, '8', $year, 'egreso');
    $setiembre = $this->Controlador_model->grafico($usuario, '9', $year, 'egreso');
    $octubre = $this->Controlador_model->grafico($usuario, '10', $year, 'egreso');
    $noviembre = $this->Controlador_model->grafico($usuario, '11', $year, 'egreso');
    $diciembre = $this->Controlador_model->grafico($usuario, '12', $year, 'egreso');
    $result = "";
    $result .= '<script type="text/javascript">$(document).ready(function() {Highcharts.chart("graficoegreso", {chart: {type: "column"},
    title: {text: "REPORTE MENSUAL DEl ' . $year . '"},xAxis: {categories: ["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Set","Oct","Nov","Dic"],crosshair: true},yAxis:
    {min: 0,title: {text: "Dinero (S/)"}}, tooltip: {headerFormat: "<table>", pointFormat: "';
    $result .= "<tr><td style='padding:0'><b>S/ {point.y:.2f}</b></td></tr>";
    $result .= '",footerFormat: "</table>",shared: true,useHTML: true},plotOptions: {column: {pointPadding: 0.20,borderWidth: 0}}
    ,series: [{name: "EGRESO", data: [' . (isset($enero->monto) ? $enero->monto : 0) . ',' . (isset($febrero->monto) ? $febrero->monto : 0) . '
    ,' . (isset($marzo->monto) ? $marzo->monto : 0) . ',' . (isset($abril->monto) ? $abril->monto : 0) . '
    ,' . (isset($mayo->monto) ? $mayo->monto : 0) . ',' . (isset($junio->monto) ? $junio->monto : 0) . '
    ,' . (isset($julio->monto) ? $julio->monto : 0) . ',' . (isset($agosto->monto) ? $agosto->monto : 0) . '
    ,' . (isset($setiembre->monto) ? $setiembre->monto : 0) . ',' . (isset($octubre->monto) ? $octubre->monto : 0) . '
    ,' . (isset($noviembre->monto) ? $noviembre->monto : 0) . ',' . (isset($ventadic->monto) ? $ventadic->monto : 0) . ']}]});});</script>';
    echo $result;
  }
}
