<?php

use Peru\Sunat\RucFactory;

class Empresa extends CI_Controller {

  public function __construct() {
    parent::__construct();
    $this->load->model(modelo(), 'Controlador_model');
    $this->controlador = controlador();
    $this->titulo_controlador = humanize($this->controlador);
    $this->url = base_url().$this->controlador;
    $this->vista = $this->controlador;
    $this->perfil = $this->session->userdata('perfil') ? $this->session->userdata('perfil') : FALSE;
    $this->usuario = $this->session->userdata('usuario') ? $this->session->userdata('usuario') : FALSE;
    $this->empresa = $this->session->userdata('empresa') ? $this->session->userdata('empresa') : FALSE;
  }

  public function index() {
    $data = array(
      'titulo' => $this->titulo_controlador,
      'contenido' => $this->vista,
    );
    $this->load->view(THEME.TEMPLATE, $data);
  }

  public function ajax_list() {
    $draw = intval($this->input->get("draw"));
    $start = intval($this->input->get("start"));
    $length = intval($this->input->get("length"));
    $query = $this->db->order_by('id', 'desc')->get($this->controlador)->result();
    $data = [];
    foreach($query as $key => $value) {
      //add variables for action
      $boton = '';
      //add html for action
      $boton .= '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="Modificar" onclick="edit('.$value->id.')"><i class="fa fa-pencil"></i></a> ';
      $boton .= '<a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Borrar" onclick="borrar('.$value->id.')"><i class="fa fa-trash"></i></a> ';
      $data[] = array(
        $key + 1,
        $value->tipo == '0' ? 'NATURAL' : 'JURIDICA',
        $value->ruc,
        $value->razonsocial,
        $value->nombre,
        substr($value->direccion, 0, 40),
        $boton
      );
    }
    $result = array(
      "draw" => $draw,
      "recordsTotal" => $start,
      "recordsFiltered" => $length,
      "data" => $data
    );
    //output to json format
    echo json_encode($result);
  }

  private function _validate() {
		$data = array();
		$data['error_string'] = array();
		$data['inputerror'] = array();
		$data['status'] = TRUE;

		if($this->input->post('documento') == '') {
			$data['inputerror'][] = 'documento';
			$data['error_string'][] = 'Este campo es obligatorio.';
			$data['status'] = FALSE;
		}

    if($this->input->post('razonsocial') == '') {
			$data['inputerror'][] = 'razonsocial';
			$data['error_string'][] = 'Este campo es obligatorio.';
			$data['status'] = FALSE;
		}

    if($this->input->post('direccion') == '') {
			$data['inputerror'][] = 'direccion';
			$data['error_string'][] = 'Este campo es obligatorio.';
			$data['status'] = FALSE;
		}

    if($this->input->post('serie') == '') {
			$data['inputerror'][] = 'serie';
			$data['error_string'][] = 'Este campo es obligatorio.';
			$data['status'] = FALSE;
		}

		if($data['status'] === FALSE) {
			echo json_encode($data);
			exit();
		}
	}

  public function ajax_add() {
		$this->_validate();
		$data['tipo'] = $this->input->post('tipo');
		$data['ruc'] = $this->input->post('documento');
		$data['razonsocial'] = $this->input->post('razonsocial');
    $data['nombre'] = $this->input->post('nombre');
		$data['serie'] = $this->input->post('serie');
		$data['direccion'] = $this->input->post('direccion');
    $data['telefono'] = $this->input->post('telefono');
		$data['celular'] = $this->input->post('celular');
		$data['departamento'] = $this->input->post('departamento');
    $data['provincia'] = $this->input->post('provincia');
		$data['distrito'] = $this->input->post('distrito');
		$data['ubigeo'] = $this->input->post('ubigeo');
		$data['usuariosol'] = $this->input->post('usuariosol');
		$data['clavesol'] = $this->input->post('clavesol');
    $data['tipoproceso'] = $this->input->post('tipoproceso');
		$data['tipoimpresora'] = $this->input->post('tipoimpresora');
		$data['nombreimpresora'] = $this->input->post('nombreimpresora');
		$this->Controlador_model->save($this->controlador, $data);
		echo json_encode(array("status" => TRUE));
	}

  public function ajax_edit($id) {
		$data = $this->Controlador_model->get_by_id($id, $this->controlador);
		echo json_encode($data);
	}

  public function ajax_update() {
		$this->_validate();
    $data['tipo'] = $this->input->post('tipo');
		$data['ruc'] = $this->input->post('documento');
		$data['razonsocial'] = $this->input->post('razonsocial');
    $data['nombre'] = $this->input->post('nombre');
		$data['serie'] = $this->input->post('serie');
		$data['direccion'] = $this->input->post('direccion');
    $data['telefono'] = $this->input->post('telefono');
		$data['celular'] = $this->input->post('celular');
		$data['departamento'] = $this->input->post('departamento');
    $data['provincia'] = $this->input->post('provincia');
		$data['distrito'] = $this->input->post('distrito');
		$data['ubigeo'] = $this->input->post('ubigeo');
		$data['usuariosol'] = $this->input->post('usuariosol');
		$data['clavesol'] = $this->input->post('clavesol');
    $data['tipoproceso'] = $this->input->post('tipoproceso');
		$data['tipoimpresora'] = $this->input->post('tipoimpresora');
		$data['nombreimpresora'] = $this->input->post('nombreimpresora');
		$this->Controlador_model->update(array('id' => $this->input->post('id')), $data, $this->controlador);
		echo json_encode(array("status" => TRUE));
	}

  public function ajax_delete($id) {
    $this->Controlador_model->delete_by_id($id, $this->controlador);
    echo json_encode(array("status" => TRUE));
	}

  public function consulta_reniec($documento) {
    $factory = new RucFactory();
    $cs = $factory->create();
    $company = $cs->get($documento);
    if ($company) {
      echo json_encode($company);
    }
  }

}
