<?php

$config = array(
    'usuario' => array(
        array(
            'field' => 'usuario',
            'label' => 'Usuario',
            'rules' => 'trim|required|unique[usuario.usuario]'
        ),
        array(
            'field' => 'password',
            'label' => 'Contraseña',
            'rules' => 'trim|required|min_length[4]'
        ),
        array(
            'field' => 're_password',
            'label' => 'Verificar Contraseña',
            'rules' => 'trim|required|min_length[4]|matches[password]'
        ),
    ),
    'actualizar_usuario' => array(
        array(
            'field' => 'usuario',
            'label' => 'Usuario',
            'rules' => 'trim|required|unique[usuario.usuario]'
        ),
        array(
            'field' => 'password',
            'label' => 'Contraseña',
            'rules' => 'trim|min_length[4]'
        ),
        array(
            'field' => 're_password',
            'label' => 'Verificar Contraseña',
            'rules' => 'trim|min_length[4]|matches[password]'
        ),
    ),
    'devolver' => array(
      array(
        'field' => 'cantidad',
        'label' => 'Cantidad',
        'rules' => 'trim|required'
      ),
    ),
    'cliente' => array(
      array(
          'field' => 'nombre',
          'label' => 'Nombre',
          'rules' => 'trim|required'
      ),
    ),
    'empresa' => array(
      array(
          'field' => 'razonsocial',
          'label' => 'Razon Social',
          'rules' => 'trim|required'

      ),
      array(
          'field' => 'ruc',
          'label' => 'RUC',
          'rules' => 'trim|required'
      ),
      array(
          'field' => 'direccion',
          'label' => 'Direccion',
          'rules' => 'trim|required'
      ),
    ),
    'proveedor' => array(
      array(
          'field' => 'nombre',
          'label' => 'Nombre',
          'rules' => 'trim|required'
      ),
      array(
          'field' => 'direccion',
          'label' => 'Direccion',
          'rules' => 'trim|required'
      ),
    ),
    'categoria' => array(
        array(
            'field' => 'categoria',
            'label' => 'Categoria',
            'rules' => 'trim|required'
        ),
    ),
    'motivo' => array(
        array(
            'field' => 'codigo',
            'label' => 'Codigo',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'motivo',
            'label' => 'Motivo',
            'rules' => 'trim|required'
        ),
    ),
    'familia' => array(
        array(
            'field' => 'nombre',
            'label' => 'Nombre',
            'rules' => 'trim|required'
        ),
    ),
    'producto' => array(
      array(
          'field' => 'preciodescuento',
          'label' => 'Precio Descuento',
          'rules' => 'trim|required'
      ),
    ),
    'marca' => array(
        array(
            'field' => 'nombre',
            'label' => 'Marca',
            'rules' => 'trim|required'
        ),
    ),
    'concepto' => array(
        array(
            'field' => 'concepto',
            'label' => 'Concepto',
            'rules' => 'trim|required'
        ),
    ),
    'cuenta' => array(
        array(
            'field' => 'pago',
            'label' => 'Monto',
            'rules' => 'trim|required'
        ),
    ),
    'compra' => array(
        array(
            'field' => 'proveedor',
            'label' => 'Proveedor',
            'rules' => 'trim|required'
        )
    ),
    'venta' => array(
        array(
            'field' => 'cliente',
            'label' => 'Cliente',
            'rules' => 'trim|required'
        ),
    ),
    'vventa' => array(
        array(
            'field' => 'cliente',
            'label' => 'Cliente',
            'rules' => 'trim|required'
        ),
    ),
    'comprar' => array(
        array(
            'field' => 'monto',
            'label' => 'Monto',
            'rules' => 'trim|required'
        ),
    ),
    'pedido' => array(
      array(
          'field' => 'monto',
          'label' => 'Monto',
          'rules' => 'trim|required'
      ),
    ),
    'pagar' => array(
        array(
            'field' => 'monto',
            'label' => 'Monto',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'fechapago',
            'label' => 'Fecha de Pago',
            'rules' => 'trim|required'
        ),
    ),
    'cambiar' => array(
        array(
            'field' => 'precioventa',
            'label' => 'Precio Venta',
            'rules' => 'trim|required'
        ),
    ),
    'cantidad' => array(
        array(
            'field' => 'numero',
            'label' => 'Cantidad',
            'rules' => 'trim|required'
        ),
    ),
    'subtotal' => array(
        array(
            'field' => 'preciodescuento',
            'label' => 'Subtotal',
            'rules' => 'trim|required'
        ),
    ),
    'perfil' => array(
        array(
            'field' => 'perfil',
            'label' => 'Perfil',
            'rules' => 'trim|required'
        ),
    ),
    'perfilmenu' => array(
        array(
            'field' => 'menu[]',
            'label' => 'Menu',
            'rules' => 'trim|required'
        ),
    ),
    'menu' => array(
        array(
            'field' => 'menu',
            'label' => 'Menu',
            'rules' => 'trim|required'
        ),
    ),
    'caja' => array(
        array(
            'field' => 'saldoinicial',
            'label' => 'Saldo Inicial',
            'rules' => 'trim|required'
        ),
    ),
    'compradetalle' => array(
        array(
            'field' => 'cantidad',
            'label' => 'Cantidad',
            'rules' => 'trim|required|is_natural_no_zero'
        ),
    ),
    'notaingreso' => array(
        array(
            'field' => 'comentario',
            'label' => 'comentario',
            'rules' => 'trim'
        ),
    ),
    'notaingresodetalle' => array(
        array(
            'field' => 'cantidad',
            'label' => 'Cantidad',
            'rules' => 'trim|required|is_natural_no_zero'
        ),
    ),
    'ventadetalle' => array(
        array(
            'field' => 'producto',
            'label' => 'Producto',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'precioventa',
            'label' => 'Precio venta',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'cantidad',
            'label' => 'Cantidad',
            'rules' => 'trim|is_natural_no_zero'
        ),
    ),
    'notasalida' => array(
        array(
            'field' => 'empresa',
            'label' => 'Empresa',
            'rules' => 'trim|required'
        ),
    ),
    'notasalidadetalle' => array(
        array(
            'field' => 'producto',
            'label' => 'Producto',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'cantidad',
            'label' => 'Cantidad',
            'rules' => 'trim|required|is_natural_no_zero'
        ),
    ),
    'egreso' => array(
        array(
            'field' => 'concepto',
            'label' => 'Concepto',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'monto',
            'label' => 'Monto',
            'rules' => 'trim|required'
        ),
    ),
    'ingreso' => array(
        array(
            'field' => 'concepto',
            'label' => 'Concepto',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'monto',
            'label' => 'Monto',
            'rules' => 'trim|required'
        ),
    ),
    'notacredito' => array(
        array(
            'field' => 'tipocredito',
            'label' => 'Tipo Operacion',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'venta',
            'label' => 'Venta',
            'rules' => 'trim|required'
        ),
    ),
    'notadebito' => array(
        array(
            'field' => 'venta',
            'label' => 'Venta',
            'rules' => 'trim|required'
        ),
    ),
    'combo' => array(
        array(
            'field' => 'combo',
            'label' => 'Combo',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'producto',
            'label' => 'Producto',
            'rules' => 'trim|required'
        ),
        array(
            'field' => 'cantidad',
            'label' => 'Cantidad',
            'rules' => 'trim|required|is_natural_no_zero'
        ),
    ),
);
